/*
 * Decompiled with CFR 0.152.
 */
package org.bluesky.blueprint.base;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.invoke.StringConcatFactory;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.LinkedBlockingQueue;
import org.bluesky.blueprint.base.BluePrintException;
import org.bluesky.blueprint.base.Logger;
import org.bluesky.blueprint.base.OPTYPE;
import org.bluesky.blueprint.base.Operator;
import org.bluesky.blueprint.base.Request;
import org.bluesky.blueprint.base.Service;
import org.bluesky.blueprint.logger.SimpleFileLogger;
import org.bluesky.blueprint.logger.SimplePrintLogger;

public class Container {
    public static String appname;
    public static HashMap<String, Container> containers;
    protected OPTYPE type;
    protected String domain;
    protected HashMap<String, Service> services;
    protected ArrayList<Operator> operators;
    protected LinkedBlockingQueue<Request> requests;
    protected static Logger logger;
    protected static Properties appProps;
    protected static String propFilePath;

    public Container(OPTYPE _type, int _numOperators) {
        this.setup(_type, "default", _numOperators);
    }

    public Container(OPTYPE _type, String _domain, int _numOperators) {
        this.setup(_type, _domain, _numOperators);
    }

    private void setup(OPTYPE _type, String _domain, int _numOperators) {
        this.type = _type;
        this.domain = _domain;
        this.services = new HashMap();
        this.requests = new LinkedBlockingQueue();
        this.operators = new ArrayList();
        for (int i = 0; i < _numOperators; ++i) {
            Operator op = new Operator(this);
            this.operators.add(op);
            op.start();
        }
        containers.put(_type.getValue() + _domain, this);
        logger.log(_type.getValue() + "[" + _domain + "] Container created");
    }

    public OPTYPE getType() {
        return this.type;
    }

    public static Logger getLogger() {
        return logger;
    }

    public static void setLogger(Logger logger) {
        Container.logger = logger;
    }

    public static void setLogger() {
        SimplePrintLogger plog = null;
        SimpleFileLogger flog = null;
        try {
            if (appProps.containsKey("logger.print.tags")) {
                plog = new SimplePrintLogger(appProps);
            }
            if (appProps.containsKey("logger.file.tags")) {
                flog = new SimpleFileLogger(appProps);
            }
            if (flog != null) {
                logger = flog;
                logger.setNext(plog);
            } else {
                logger = plog;
            }
        }
        catch (Exception e) {
            System.err.println("Cannot setup logging due to exception " + e.getMessage());
        }
    }

    public String getDomain() {
        return this.domain;
    }

    public HashMap<String, Service> getServices() {
        return this.services;
    }

    public void addService(Service a_service) {
        this.services.put(a_service.subType, a_service);
    }

    public Service getService(String a_subType) {
        return this.services.get(a_subType);
    }

    public void request(Request _request) {
        if (_request.type == this.type && _request.domain == this.domain) {
            this.requests.add(_request);
        } else {
            Container.containers.get((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001\u0001"}, (String)_request.type.getValue(), (String)_request.domain)).requests.add(_request);
        }
    }

    public static void loadProperties(String propfile) throws BluePrintException {
        try {
            FileInputStream input = new FileInputStream(propfile);
            appProps = new Properties();
            appProps.load(input);
            propFilePath = propfile;
        }
        catch (IOException e) {
            logger.error("Cound not load properties file from " + propfile);
            throw new BluePrintException("Cound not load properties file from " + propfile);
        }
    }

    public static void saveProperties() throws BluePrintException {
        try {
            FileOutputStream fr = new FileOutputStream(propFilePath);
            appProps.store(fr, "Update by BluePrint " + new Date().getTime());
        }
        catch (Exception e) {
            logger.error("Cound not save properties file to " + propFilePath);
            throw new BluePrintException("Cound not save properties file to " + propFilePath);
        }
    }

    public static Properties getAppProperties() {
        return appProps;
    }

    static {
        containers = new HashMap();
        appProps = null;
        propFilePath = "";
    }
}

