/*
 * Decompiled with CFR 0.152.
 */
package org.bluesky.blueprint.base;

import org.bluesky.blueprint.base.Container;
import org.bluesky.blueprint.base.Request;
import org.bluesky.blueprint.base.Service;

public class Operator
extends Thread {
    protected Container container;
    protected Request request;
    protected Service service;

    public Operator(Container _container) {
        this.container = _container;
        this.request = null;
    }

    public Container getContainer() {
        return this.container;
    }

    public Request getRequest() {
        return this.request;
    }

    public Service getService() {
        return this.service;
    }

    @Override
    public void run() {
        super.run();
        while (!this.isInterrupted()) {
            try {
                this.request = this.container.requests.take();
                this.service = this.container.getService(this.request.service);
                if (this.service != null) {
                    try {
                        this.service.doWork(this.request);
                        this.request.status = Request.Status.RESPONSE;
                        Container.logger.debug("Service with id " + this.request.service + " sucessfully executed");
                    }
                    catch (Exception e) {
                        this.request.status = Request.Status.FAULT;
                        Container.logger.debug("Service with id " + this.request.service + " failed to execute with error" + e.getMessage());
                        this.request.setFaultException(e);
                    }
                } else {
                    Container.logger.error("No Service defined with ID " + this.request.service);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (this.request.getCallingService() == null) continue;
            Container.logger.debug("Notify call service " + this.request.getCallingService().getSubType());
            this.request.getCallingService().done(this.request);
        }
    }
}

