/*
 * Decompiled with CFR 0.152.
 */
package org.bluesky.blueprint.data;

import java.util.ArrayList;
import org.bluesky.blueprint.base.Request;
import org.bluesky.blueprint.base.Service;
import org.bluesky.blueprint.data.DataContext;
import org.bluesky.blueprint.data.DataObject;
import org.bluesky.blueprint.data.DataRequest;

public class DataClient {
    private Service service;

    public DataClient(Service a_service) {
        this.service = a_service;
    }

    public void CreateODatabject(DataObject a_obj, DataContext o_dc) throws Exception {
        if (o_dc == null) {
            o_dc = new DataContext();
        }
        o_dc.objects.put(a_obj.getBPID(), a_obj);
        DataRequest dr = new DataRequest(a_obj.getDomain(), "CreateObject", this.service);
        dr.addContext(o_dc);
        dr.setPbid(a_obj.getBPID());
        this.service.request(dr);
        this.service.response(dr.getID());
        if (dr.getStatus() == Request.Status.FAULT) {
            throw dr.getFaultException();
        }
    }

    public DataObject FetchDataObject(DataObject a_obj, DataContext o_dc) throws Exception {
        if (o_dc == null) {
            o_dc = new DataContext();
        }
        o_dc.objects.put(a_obj.getBPID(), a_obj);
        DataRequest dr = new DataRequest(a_obj.getDomain(), "FetchObject", this.service);
        dr.addContext(o_dc);
        dr.setPbid(a_obj.getBPID());
        this.service.request(dr);
        this.service.response(dr.getID());
        if (dr.getStatus() == Request.Status.FAULT) {
            throw dr.getFaultException();
        }
        return o_dc.objects.get(a_obj.getBPID());
    }

    public DataObject UpdateDataObject(DataObject a_obj, DataContext o_dc) throws Exception {
        if (o_dc == null) {
            o_dc = new DataContext();
        }
        o_dc.objects.put(a_obj.getBPID(), a_obj);
        DataRequest dr = new DataRequest(a_obj.getDomain(), "UpdateObject", this.service);
        dr.addContext(o_dc);
        dr.setPbid(a_obj.getBPID());
        this.service.request(dr);
        this.service.response(dr.getID());
        if (dr.getStatus() == Request.Status.FAULT) {
            throw dr.getFaultException();
        }
        return o_dc.objects.get(a_obj.getBPID());
    }

    public DataObject DeleteDataObject(DataObject a_obj, DataContext o_dc) throws Exception {
        if (o_dc == null) {
            o_dc = new DataContext();
        }
        o_dc.objects.put(a_obj.getBPID(), a_obj);
        DataRequest dr = new DataRequest(a_obj.getDomain(), "DeleteObject", this.service);
        dr.addContext(o_dc);
        dr.setPbid(a_obj.getBPID());
        this.service.request(dr);
        this.service.response(dr.getID());
        if (dr.getStatus() == Request.Status.FAULT) {
            throw dr.getFaultException();
        }
        return o_dc.objects.get(a_obj.getBPID());
    }

    public ArrayList<DataObject> FetchManyDataObjects(DataObject classobj, DataContext o_dc) throws Exception {
        if (o_dc == null) {
            o_dc = new DataContext();
        }
        DataRequest dr = new DataRequest(classobj.getDomain(), "FetchMany", this.service);
        dr.addContext(o_dc);
        dr.setClassObj(classobj);
        this.service.request(dr);
        this.service.response(dr.getID());
        if (dr.getStatus() == Request.Status.FAULT) {
            throw dr.getFaultException();
        }
        return o_dc.objectLists.get(classobj.getName());
    }
}

