/*
 * Decompiled with CFR 0.152.
 */
package org.bluesky.blueprint.data.mongo;

import com.google.gson.Gson;
import com.mongodb.client.model.Filters;
import org.bluesky.blueprint.base.BluePrintException;
import org.bluesky.blueprint.base.Container;
import org.bluesky.blueprint.base.OPTYPE;
import org.bluesky.blueprint.base.Request;
import org.bluesky.blueprint.base.Service;
import org.bluesky.blueprint.data.DataContext;
import org.bluesky.blueprint.data.DataObject;
import org.bluesky.blueprint.data.DataRequest;
import org.bluesky.blueprint.data.mongo.DataContainerMongo;
import org.bson.Document;
import org.bson.conversions.Bson;

public class DataMongoCreateService
extends Service {
    private Gson gson = new Gson();

    public DataMongoCreateService(Container a_owner) {
        super("CreateObject", a_owner);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void doWork(Request a_request) throws Exception {
        DataRequest dr = (DataRequest)a_request;
        DataContainerMongo dcm = (DataContainerMongo)this.owner;
        DataContext dc = (DataContext)a_request.getContext(OPTYPE.DATA);
        DataObject dobj = dc.objects.get(dr.getPbid());
        if (dobj == null || !dobj.getDomain().equals(dcm.getDomain())) throw new BluePrintException(this, "No object or object not of domain " + this.owner.getDomain());
        Bson filter = Filters.eq("BPID", dobj.getBPID());
        Document doc = (Document)dcm.getDatabase().getCollection(dobj.getClass().getSimpleName()).find(filter).first();
        if (doc != null) throw new BluePrintException(this, "Failed to insert Data Object of type " + dobj.getClass().getSimpleName() + " with ID " + dobj.getBPID() + "into Mongo Collection of same name as ID already exists in the collection");
        String json = this.gson.toJson(dobj);
        doc = Document.parse(json);
        dcm.getDatabase().getCollection(dobj.getClass().getSimpleName()).insertOne(doc);
        doc = (Document)dcm.getDatabase().getCollection(dobj.getClass().getSimpleName()).find(filter).first();
        if (doc == null) {
            throw new BluePrintException(this, "Failed to insert Data Object of type " + dobj.getClass().getSimpleName() + " with ID " + dobj.getBPID() + "into Mongo Collection of same name");
        }
        Container.getLogger().debug("Data Object of type " + dobj.getClass().getSimpleName() + " with ID " + dobj.getBPID() + " inserted into Mongo Collection of same name");
    }
}

