/*
 * Decompiled with CFR 0.152.
 */
package org.bluesky.blueprint.data.postgres;

import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Time;
import java.util.ArrayList;
import org.bluesky.blueprint.base.BluePrintException;
import org.bluesky.blueprint.base.Container;
import org.bluesky.blueprint.data.DataContainer;
import org.bluesky.blueprint.data.DataObject;
import org.bluesky.blueprint.data.DataObjectAttribute;
import org.bluesky.blueprint.data.postgres.DataPostgresCreateService;
import org.bluesky.blueprint.data.postgres.DataPostgresDeleteService;
import org.bluesky.blueprint.data.postgres.DataPostgresFetchManyService;
import org.bluesky.blueprint.data.postgres.DataPostgresFetchService;
import org.bluesky.blueprint.data.postgres.DataPostgresUpdateService;

public class DataContainerPostgres
extends DataContainer {
    private ArrayList<Connection> pool;

    public DataContainerPostgres(int a_numOfOperators) {
        super(a_numOfOperators);
    }

    public DataContainerPostgres(String a_domain, int a_numOfOperators) {
        super(a_domain, a_numOfOperators);
    }

    public void setup(String a_dburl, String a_urename, String a_password, int a_poolsize) throws BluePrintException {
        this.pool = new ArrayList();
        try {
            Class.forName("org.postgresql.Driver");
        }
        catch (ClassNotFoundException e) {
            logger.error("Postgres Data Container cannot load Postgres driver " + e.getMessage());
            throw new BluePrintException("Cannot load Postgres driver " + e.getMessage());
        }
        for (int i = 0; i < a_poolsize; ++i) {
            try {
                this.pool.add(DriverManager.getConnection(a_dburl, a_urename, a_password));
                continue;
            }
            catch (Exception e) {
                logger.error("Postgres Data Container cannot establish connection for pool using url " + a_dburl + " error message " + e.getMessage());
                throw new BluePrintException("Postgres Data Container cannot establish connection for pool using url " + a_dburl + " error message " + e.getMessage());
            }
        }
        this.addService(new DataPostgresCreateService(this));
        this.addService(new DataPostgresCreateService(this));
        this.addService(new DataPostgresDeleteService(this));
        this.addService(new DataPostgresFetchManyService(this));
        this.addService(new DataPostgresFetchService(this));
        this.addService(new DataPostgresUpdateService(this));
        logger.log("Postgres Data Container connection pool establsihed with " + a_poolsize + " connections");
    }

    public Connection getConnection() throws BluePrintException {
        Connection c = null;
        if (this.pool.isEmpty()) {
            logger.error("Postgres Connection pool is empty on get connection request");
            throw new BluePrintException("Connection pool is empty");
        }
        c = this.pool.remove(0);
        return c;
    }

    public void freeConnection(Connection a_conn) {
        this.pool.add(a_conn);
    }

    public boolean createTable(DataObject a_do) throws BluePrintException {
        boolean ret = true;
        Object sql = "CREATE TABLE IF NOT EXISTS ";
        sql = (String)sql + a_do.getDomain() + "." + a_do.getName() + " (PBID VARCHAR(36) NOT NULL UNIQUE PRIMARY KEY ";
        for (DataObjectAttribute attr : a_do.getAttributeMetaData()) {
            sql = (String)sql + ", " + attr.name;
            if (attr.type == DataObjectAttribute.DataType.STRING) {
                sql = (String)sql + " VARCHAR(" + attr.size + ")";
                continue;
            }
            sql = (String)sql + " " + attr.type.toString();
        }
        sql = (String)sql + ")";
        Connection c = null;
        try {
            c = this.getConnection();
            Statement stmnt = c.createStatement();
            stmnt.execute((String)sql);
            sql = "SELECT COUNT(*) FROM " + a_do.getDomain() + "." + a_do.getName();
            ResultSet rs = stmnt.executeQuery((String)sql);
            rs.next();
            if (rs.getInt(1) == 0) {
                ret = true;
                logger.debug("Table created for Data Object " + a_do.getName() + " with SQL " + (String)sql);
            } else {
                ret = false;
                logger.debug("Table exists for Data Object " + a_do.getName() + " with " + rs.getInt(1) + " object in.");
            }
        }
        catch (Exception e) {
            String msg = "Faild to Table for Data Object " + a_do.getName() + " with SQL " + (String)sql + " with exception " + e.getMessage();
            logger.error(msg);
            throw new BluePrintException(msg);
        }
        finally {
            if (c != null) {
                this.freeConnection(c);
            }
        }
        return ret;
    }

    public void insertObject(DataObject a_obj) throws BluePrintException {
        Object sql = "INSERT INTO ";
        Object vals = " VALUES( ?";
        sql = (String)sql + a_obj.getDomain() + "." + a_obj.getName();
        sql = (String)sql + "( PBID";
        for (DataObjectAttribute attr : a_obj.getAttributeMetaData()) {
            sql = (String)sql + ", " + attr.name;
            vals = (String)vals + ",? ";
        }
        sql = (String)sql + ")" + (String)vals + ")";
        Connection c = null;
        try {
            c = this.getConnection();
            PreparedStatement stmnt = c.prepareStatement((String)sql);
            stmnt.setString(1, a_obj.getBPID());
            int i = 2;
            for (DataObjectAttribute attr : a_obj.getAttributeMetaData()) {
                switch (attr.type) {
                    case STRING: {
                        stmnt.setString(i, (String)a_obj.getAttribute(attr.name));
                        break;
                    }
                    case INTEGER: {
                        stmnt.setInt(i, (Integer)a_obj.getAttribute(attr.name));
                        break;
                    }
                    case FLOAT: {
                        stmnt.setDouble(i, (Double)a_obj.getAttribute(attr.name));
                        break;
                    }
                    case DATE: {
                        stmnt.setDate(i, (Date)a_obj.getAttribute(attr.name));
                        break;
                    }
                    case TIME: {
                        stmnt.setTime(i, (Time)a_obj.getAttribute(attr.name));
                        break;
                    }
                    case TIMESTAMP: {
                        stmnt.setTime(i, (Time)a_obj.getAttribute(attr.name));
                    }
                }
                ++i;
            }
            stmnt.executeUpdate();
            Container.getLogger().debug("created (Insert) Data Object " + a_obj.getName() + " with SQL " + (String)sql);
        }
        catch (Exception e) {
            String msg = "Failed to Create (Insert) Data Object " + a_obj.getName() + " with SQL " + (String)sql + " with exception " + e.getMessage();
            Container.getLogger().error(msg);
            throw new BluePrintException(msg);
        }
        finally {
            if (c != null) {
                this.freeConnection(c);
            }
        }
    }
}

