/*
 * Decompiled with CFR 0.152.
 */
package org.bluesky.blueprint.data.postgres;

import java.sql.Connection;
import java.sql.PreparedStatement;
import org.bluesky.blueprint.base.BluePrintException;
import org.bluesky.blueprint.base.Container;
import org.bluesky.blueprint.base.OPTYPE;
import org.bluesky.blueprint.base.Request;
import org.bluesky.blueprint.base.Service;
import org.bluesky.blueprint.data.DataContext;
import org.bluesky.blueprint.data.DataObject;
import org.bluesky.blueprint.data.postgres.DataContainerPostgres;

public class DataPostgresDeleteService
extends Service {
    public DataPostgresDeleteService(Container a_owner) {
        super("DeleteObject", a_owner);
    }

    @Override
    public void doWork(Request a_request) throws Exception {
        DataContainerPostgres dcp = (DataContainerPostgres)this.owner;
        DataContext dc = (DataContext)a_request.getContext(OPTYPE.DATA);
        DataObject dobj = (DataObject)dc.objects.values().toArray()[0];
        if (dobj != null && dobj.getDomain().equals(dcp.getDomain())) {
            String sql = "DELETE FROM " + dobj.getDomain() + "." + dobj.getName() + " WHERE PBID = ? ";
            Connection c = null;
            try {
                c = ((DataContainerPostgres)this.owner).getConnection();
                PreparedStatement stmnt = c.prepareStatement(sql);
                stmnt.setString(1, dobj.getBPID());
                stmnt.execute();
                String msg = "Deleted Data Object " + dobj.getName() + " with PBID " + dobj.getBPID() + " Using SQL Text " + sql;
                Container.getLogger().debug(msg);
            }
            catch (Exception e) {
                String msg = "Failed to Delete Data Object " + dobj.getName() + " with PBID " + dobj.getBPID() + " Using SQL Text " + sql + " Exception " + e.getMessage();
                Container.getLogger().error(msg);
                throw new BluePrintException(msg);
            }
            finally {
                if (c != null) {
                    ((DataContainerPostgres)this.owner).freeConnection(c);
                }
            }
        } else {
            throw new BluePrintException(this, "No object or object not of domain " + this.owner.getDomain());
        }
    }
}

