/*
 * Decompiled with CFR 0.152.
 */
package org.bluesky.blueprint.data.postgres;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.bluesky.blueprint.base.BluePrintException;
import org.bluesky.blueprint.base.Container;
import org.bluesky.blueprint.base.OPTYPE;
import org.bluesky.blueprint.base.Request;
import org.bluesky.blueprint.base.Service;
import org.bluesky.blueprint.data.DataContext;
import org.bluesky.blueprint.data.DataObject;
import org.bluesky.blueprint.data.DataObjectAttribute;
import org.bluesky.blueprint.data.postgres.DataContainerPostgres;

public class DataPostgresFetchService
extends Service {
    public DataPostgresFetchService(Container a_owner) {
        super("FetchObject", a_owner);
    }

    @Override
    public void doWork(Request a_request) throws Exception {
        DataContainerPostgres dcp = (DataContainerPostgres)this.owner;
        DataContext dc = (DataContext)a_request.getContext(OPTYPE.DATA);
        DataObject dobj = (DataObject)dc.objects.values().toArray()[0];
        if (dobj != null && dobj.getDomain().equals(dcp.getDomain())) {
            String sql = "SELECT * FROM " + dobj.getDomain() + "." + dobj.getName() + " WHERE PBID = ? ";
            Connection c = null;
            try {
                c = ((DataContainerPostgres)this.owner).getConnection();
                PreparedStatement stmnt = c.prepareStatement(sql);
                stmnt.setString(1, dobj.getBPID());
                ResultSet rs = stmnt.executeQuery();
                rs.next();
                for (DataObjectAttribute attr : dobj.getAttributeMetaData()) {
                    switch (attr.type) {
                        case STRING: {
                            dobj.setAttribute(attr.name, rs.getString(attr.name.toLowerCase()));
                            break;
                        }
                        case INTEGER: {
                            dobj.setAttribute(attr.name, rs.getInt(attr.name.toLowerCase()));
                            break;
                        }
                        case FLOAT: {
                            dobj.setAttribute(attr.name, rs.getDouble(attr.name.toLowerCase()));
                            break;
                        }
                        case DATE: {
                            dobj.setAttribute(attr.name, rs.getDate(attr.name.toLowerCase()));
                            break;
                        }
                        case TIME: {
                            dobj.setAttribute(attr.name, rs.getTime(attr.name.toLowerCase()));
                            break;
                        }
                        case TIMESTAMP: {
                            dobj.setAttribute(attr.name, rs.getTimestamp(attr.name.toLowerCase()));
                        }
                    }
                }
                String msg = "Fetched Data Object " + dobj.getName() + " with PBID " + dobj.getBPID() + " Using SQL Text " + sql;
                Container.getLogger().debug(msg);
            }
            catch (Exception e) {
                String msg = "Failed to Fetch Data Object " + dobj.getName() + " with PBID " + dobj.getBPID() + " Using SQL Text " + sql + " Exception " + e.getMessage();
                Container.getLogger().error(msg);
                throw new BluePrintException(msg);
            }
            finally {
                if (c != null) {
                    ((DataContainerPostgres)this.owner).freeConnection(c);
                }
            }
        } else {
            throw new BluePrintException(this, "No object or object not of domain " + this.owner.getDomain());
        }
    }
}

