/*
 * Decompiled with CFR 0.152.
 */
package org.bluesky.blueprint.data.postgres;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Time;
import java.sql.Timestamp;
import org.bluesky.blueprint.base.BluePrintException;
import org.bluesky.blueprint.base.Container;
import org.bluesky.blueprint.base.OPTYPE;
import org.bluesky.blueprint.base.Request;
import org.bluesky.blueprint.base.Service;
import org.bluesky.blueprint.data.DataContext;
import org.bluesky.blueprint.data.DataObject;
import org.bluesky.blueprint.data.DataObjectAttribute;
import org.bluesky.blueprint.data.postgres.DataContainerPostgres;

public class DataPostgresUpdateService
extends Service {
    public DataPostgresUpdateService(Container a_owner) {
        super("UpdateObject", a_owner);
    }

    @Override
    public void doWork(Request a_request) throws Exception {
        DataContainerPostgres dcp = (DataContainerPostgres)this.owner;
        DataContext dc = (DataContext)a_request.getContext(OPTYPE.DATA);
        DataObject dobj = (DataObject)dc.objects.values().toArray()[0];
        if (dobj != null && dobj.getDomain().equals(dcp.getDomain())) {
            String sql = "UPDATE " + dobj.getDomain() + "." + dobj.getName() + " SET";
            for (DataObjectAttribute attr : dobj.getAttributeMetaData()) {
                if (!sql.endsWith("SET")) {
                    sql = sql + ",";
                }
                sql = sql + " " + attr.name.toLowerCase() + " = ?";
            }
            sql = sql + " WHERE pbid = ? ";
            Connection c = null;
            try {
                c = ((DataContainerPostgres)this.owner).getConnection();
                PreparedStatement stmnt = c.prepareStatement(sql);
                int param = 1;
                for (DataObjectAttribute attr : dobj.getAttributeMetaData()) {
                    switch (attr.type) {
                        case STRING: {
                            stmnt.setString(param, (String)dobj.getAttribute(attr.name));
                            break;
                        }
                        case INTEGER: {
                            stmnt.setInt(param, (Integer)dobj.getAttribute(attr.name));
                            break;
                        }
                        case FLOAT: {
                            stmnt.setDouble(param, (Double)dobj.getAttribute(attr.name));
                            break;
                        }
                        case DATE: {
                            stmnt.setDate(param, (Date)dobj.getAttribute(attr.name));
                            break;
                        }
                        case TIME: {
                            stmnt.setTime(param, (Time)dobj.getAttribute(attr.name));
                            break;
                        }
                        case TIMESTAMP: {
                            stmnt.setTimestamp(param, (Timestamp)dobj.getAttribute(attr.name));
                        }
                    }
                    ++param;
                }
                stmnt.setString(param, dobj.getBPID());
                stmnt.execute();
                String msg = "Updated Data Object " + dobj.getName() + " with PBID " + dobj.getBPID() + " Using SQL Text " + sql;
                Container.getLogger().debug(msg);
            }
            catch (Exception e) {
                String msg = "Failed to Update Data Object " + dobj.getName() + " with PBID " + dobj.getBPID() + " Using SQL Text " + sql + " Exception " + e.getMessage();
                Container.getLogger().error(msg);
                throw new BluePrintException(msg);
            }
            finally {
                if (c != null) {
                    ((DataContainerPostgres)this.owner).freeConnection(c);
                }
            }
        } else {
            throw new BluePrintException(this, "No object or object not of domain " + this.owner.getDomain());
        }
    }
}

