/*
 * Decompiled with CFR 0.152.
 */
package org.bluesky.blueprint.data.yaml;

import java.util.ArrayList;
import java.util.HashMap;
import org.bluesky.blueprint.base.BluePrintException;
import org.bluesky.blueprint.base.Logger;
import org.bluesky.blueprint.data.DataObjectAttribute;
import org.bluesky.blueprint.data.yaml.DocumentDataObject;

public class DataYamlDocument {
    private DocumentDataObject document;
    private HashMap<Integer, DocumentDataObject> previous;
    private DocumentDataObject currentObject;
    private ArrayList<DocumentDataObject> currentList;
    private int currentIndent = 0;
    private DocumentDataObject parent = null;
    private String currentName;
    private Logger logger;

    public DataYamlDocument(Logger a_logger) {
        this.logger = a_logger;
        this.previous = new HashMap();
    }

    public DocumentDataObject getDocument() {
        return this.document;
    }

    public void parseDoc(ArrayList<String> a_doc) throws BluePrintException {
        int lastIndent = 0;
        this.logger.log("Start parse document");
        for (int index = 0; index < a_doc.size(); ++index) {
            LineEval eval = this.evaluateLine(a_doc.get(index));
            if (eval.isEmpty) continue;
            if (eval.isDocStart) {
                this.currentObject = this.document = new DocumentDataObject(null, "doc");
                this.previous.put(eval.indent, this.currentObject);
                this.logger.log("Adding default object to document");
                continue;
            }
            if (eval.indent < lastIndent) {
                this.currentObject = this.previous.get(eval.indent);
            }
            lastIndent = eval.indent;
            if (!eval.mapName.isEmpty()) {
                if (eval.indent == 0) {
                    this.currentObject = this.document;
                    this.currentIndent = 0;
                    this.currentName = "";
                }
                LineEval next = this.evaluateLine(a_doc.get(index + 1));
                if (next.isItem) {
                    if (next.key.isEmpty()) {
                        this.currentObject.addAttributeMetadata(new DataObjectAttribute(eval.mapName, DataObjectAttribute.DataType.STRING, 0));
                        ArrayList<String> items = new ArrayList<String>();
                        ++index;
                        while (index < a_doc.size() && next.isItem && next.key.isEmpty()) {
                            if (next.isItem) {
                                items.add(next.value.toString());
                            }
                            if (++index >= a_doc.size()) continue;
                            next = this.evaluateLine(a_doc.get(index));
                        }
                        this.currentObject.setAttribute(eval.mapName, items);
                        Object values = "[";
                        for (String s2 : items) {
                            values = (String)values + s2 + ",";
                        }
                        values = (String)values + "]";
                        --index;
                        if (this.currentList == null) {
                            this.logger.log("Adding String Arrary attribute " + eval.mapName + " with values " + (String)values + "  to object " + this.currentObject.getQualifiedName());
                            continue;
                        }
                        this.logger.log("Adding String Arrary attribute " + eval.mapName + " with values " + (String)values + "  to object " + this.currentObject.getQualifiedName() + "[" + this.currentList.size() + "]");
                        continue;
                    }
                    this.currentList = new ArrayList();
                    this.currentObject.setAttribute(eval.mapName, this.currentList);
                    this.currentObject.addAttributeMetadata(new DataObjectAttribute(eval.mapName, DataObjectAttribute.DataType.OBJECT, 0));
                    this.parent = this.currentObject;
                    this.currentName = eval.mapName;
                    this.previous.put(this.currentIndent, this.currentObject);
                    this.currentIndent = eval.indent;
                    this.logger.log("Adding Object Arrary attribute " + eval.mapName + "  to object " + this.parent.getQualifiedName());
                    continue;
                }
                if (eval.isItem) continue;
                this.currentList = new ArrayList();
                this.currentObject.setAttribute(eval.mapName, this.currentList);
                this.currentObject.addAttributeMetadata(new DataObjectAttribute(eval.mapName, DataObjectAttribute.DataType.OBJECT, 0));
                this.parent = this.currentObject;
                this.currentName = eval.mapName;
                this.currentIndent = eval.indent;
                this.previous.put(this.currentIndent, this.currentObject);
                this.logger.log("Adding Object Arrary attribute " + eval.mapName + "  to object " + this.parent.getQualifiedName());
                this.currentObject = new DocumentDataObject(this.parent, this.currentName);
                this.currentList.add(this.currentObject);
                this.logger.log("Adding sub-object " + this.currentName + "[" + this.currentList.size() + "] to " + this.parent.getQualifiedName());
                continue;
            }
            if (eval.isItem) {
                this.currentObject = new DocumentDataObject(this.parent, this.currentName);
                this.currentList.add(this.currentObject);
                this.logger.log("Adding sub-object " + this.currentName + "[" + this.currentList.size() + "] to " + this.parent.getQualifiedName());
                if (!this.currentObject.hasMetaAttribute(eval.key)) {
                    this.currentObject.addAttributeMetadata(new DataObjectAttribute(eval.key, eval.dataType, 0));
                    this.logger.log("Adding attribute metadata " + eval.key + " of type " + eval.dataType.toString() + " to object " + this.currentObject.getQualifiedName());
                }
                this.currentObject.setAttribute(eval.key, eval.value);
                if (this.currentList != null) {
                    this.logger.log("Adding attribute " + eval.key + " with values \"" + String.valueOf(eval.value) + "\"  to object " + this.currentObject.getQualifiedName() + "[" + this.currentList.size() + "]");
                    continue;
                }
                this.logger.log("Adding attribute " + eval.key + " with values \"" + String.valueOf(eval.value) + "\"  to object " + this.currentObject.getQualifiedName());
                continue;
            }
            if (eval.key.isEmpty()) continue;
            if (!this.currentObject.hasMetaAttribute(eval.key)) {
                this.currentObject.addAttributeMetadata(new DataObjectAttribute(eval.key, eval.dataType, 0));
                this.logger.log("Adding attribute metadata " + eval.key + " of type " + eval.dataType.toString() + " to object " + this.currentObject.getQualifiedName());
            }
            this.currentObject.setAttribute(eval.key, eval.value);
            if (this.currentList != null) {
                this.logger.log("Adding attribute " + eval.key + " with value \"" + String.valueOf(eval.value) + "\"  to object " + this.currentObject.getQualifiedName() + "[" + this.currentList.size() + "]");
                continue;
            }
            this.logger.log("Adding attribute " + eval.key + " with value \"" + String.valueOf(eval.value) + "\"  to object " + this.currentObject.getQualifiedName());
        }
        this.logger.log("End parse document");
    }

    public ArrayList<LineEval> parseDocToEval(ArrayList<String> a_doc, boolean a_consolidateStrings, boolean a_skipBlanks, boolean a_skipComments) throws BluePrintException {
        int index = 0;
        ArrayList<LineEval> ret = new ArrayList<LineEval>();
        this.logger.log("Start parse document");
        while (index < a_doc.size()) {
            LineEval eval = this.evaluateLine(a_doc.get(index));
            if (eval.isEmpty) {
                if (!a_skipBlanks) {
                    ret.add(eval);
                }
                ++index;
                continue;
            }
            if (!eval.comment.isEmpty() && eval.indent == 0 && !a_skipComments) {
                ret.add(eval);
                ++index;
                continue;
            }
            ret.add(eval);
            ++index;
        }
        this.logger.log(index + " lines parsed");
        return ret;
    }

    private LineEval evaluateLine(String a_line) throws BluePrintException {
        LineEval ret;
        block26: {
            ret = new LineEval();
            String line = a_line;
            String svalue = "";
            ret.line = a_line;
            ret.isEmpty = a_line.trim().isEmpty();
            if (!ret.isEmpty) {
                ret.isDocStart = line.startsWith("---");
                if (!ret.isDocStart) {
                    int index;
                    for (index = 0; index < line.length() && line.charAt(index) != '#'; ++index) {
                        if (line.charAt(index) != '\\') continue;
                        ++index;
                    }
                    if (index < line.length() && line.charAt(index) == '#') {
                        ret.comment = line.substring(index + 1);
                        if (index > 0) {
                            line = line.substring(0, index - 1);
                        } else {
                            line = "";
                            ret.isEmpty = true;
                        }
                    }
                    index = 0;
                    while (index < line.length() && line.charAt(index) == ' ') {
                        ++index;
                        ++ret.indent;
                    }
                    if (ret.indent > 0) {
                        ++ret.indent;
                    }
                    line = line.trim();
                    ret.isItem = line.startsWith("- ");
                    if (ret.isItem) {
                        line = line.substring(2);
                        String[] parts = line.split(": ");
                        if (line.charAt(0) == '\"' || line.charAt(0) == '\'' || parts.length == 1) {
                            ret.value = line;
                        } else {
                            ret.key = parts[0];
                            svalue = line.replace(parts[0] + ": ", "");
                        }
                    } else if (line.trim().endsWith(":")) {
                        ret.mapName = line.replace(":", "");
                    } else {
                        String[] parts = line.split(": ");
                        ret.key = parts[0];
                        svalue = line.replace(parts[0] + ": ", "");
                    }
                    if (!svalue.isEmpty()) {
                        if (svalue.equals("|") || svalue.equals(">")) {
                            // empty if block
                        }
                        if (svalue.equals("true") || svalue.equals("false")) {
                            ret.dataType = DataObjectAttribute.DataType.BOOLEAN;
                            ret.value = svalue.equals("true");
                        } else {
                            try {
                                ret.value = Integer.parseInt(svalue);
                                ret.dataType = DataObjectAttribute.DataType.INTEGER;
                            }
                            catch (Exception e) {
                                try {
                                    ret.value = Double.parseDouble(svalue);
                                    ret.dataType = DataObjectAttribute.DataType.FLOAT;
                                }
                                catch (Exception e1) {
                                    if (svalue.startsWith("\"")) {
                                        if (svalue.endsWith("\"")) {
                                            ret.value = svalue.substring(1, svalue.length() - 1);
                                            ret.dataType = DataObjectAttribute.DataType.STRING;
                                            break block26;
                                        }
                                        throw new BluePrintException("Expecting string terminator in line " + ret.line);
                                    }
                                    if (svalue.startsWith("'")) {
                                        if (svalue.endsWith("'")) {
                                            ret.value = svalue.substring(1, svalue.length() - 1);
                                            ret.dataType = DataObjectAttribute.DataType.STRING;
                                            break block26;
                                        }
                                        throw new BluePrintException("Expecting string terminator in line " + ret.line);
                                    }
                                    ret.dataType = DataObjectAttribute.DataType.STRING;
                                    ret.value = svalue;
                                }
                            }
                        }
                    }
                }
            }
        }
        return ret;
    }

    public class LineEval {
        String line = "";
        boolean isEmpty = true;
        String comment = "";
        int indent = 0;
        String mapName = "";
        boolean isItem = false;
        String key = "";
        Object value = null;
        boolean isDocStart = false;
        DataObjectAttribute.DataType dataType;

        public String print() {
            Object ret = "";
            if (this.isEmpty) {
                ret = (String)ret + "Empty";
            } else if (this.isDocStart) {
                ret = (String)ret + "Document Start";
            } else {
                ret = (String)ret + " Indent = " + this.indent;
                if (this.isItem) {
                    ret = (String)ret + " Is Item ";
                }
                ret = (String)ret + " MapName = " + this.mapName + " key = " + this.key;
                if (this.value != null) {
                    ret = (String)ret + " value[" + this.dataType.toString() + "] = " + this.value.toString();
                }
            }
            return ret;
        }
    }
}

