/*
 * Decompiled with CFR 0.152.
 */
package org.bluesky.blueprint.data.yaml;

import java.util.ArrayList;
import java.util.HashMap;
import org.bluesky.blueprint.data.DataObject;
import org.bluesky.blueprint.data.DataObjectAttribute;

public class DocumentDataObject
extends DataObject {
    private String name;
    private String qualName;
    private DocumentDataObject parent;
    private static HashMap<String, ArrayList<DataObjectAttribute>> Metadata = new HashMap();
    private ArrayList<AttrData> attributeByList = new ArrayList();

    public DocumentDataObject(DocumentDataObject a_parent, String a_name) {
        this.name = a_name;
        this.qualName = a_parent != null ? a_parent.qualName + "." + a_name : a_name;
        this.parent = a_parent;
        if (!Metadata.containsKey(this.qualName)) {
            Metadata.put(this.qualName, new ArrayList());
        }
    }

    @Override
    public DataObject CreateDataObject(String a_PBID) {
        throw new UnsupportedOperationException("Unimplemented method 'CreateDataObject'");
    }

    @Override
    public String getDomain() {
        return "document";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ArrayList<DataObjectAttribute> getAttributeMetaData() {
        return Metadata.get(this.qualName);
    }

    public void addAttributeMetadata(DataObjectAttribute a_attr) {
        Metadata.get(this.qualName).add(a_attr);
    }

    public boolean hasMetaAttribute(String a_name) {
        ArrayList<DataObjectAttribute> l = Metadata.get(this.qualName);
        boolean found = false;
        for (int i = 0; i < l.size() && !found; ++i) {
            found = l.get((int)i).name.equals(a_name);
        }
        return found;
    }

    public DocumentDataObject getParent() {
        return this.parent;
    }

    public String getQualifiedName() {
        return this.qualName;
    }

    @Override
    public void setAttribute(String a_name, Object a_attr) {
        super.setAttribute(a_name, a_attr);
        this.attributeByList.add(new AttrData(a_name, a_attr));
    }

    public String showDoc(int indent, int index) {
        Object ret = "";
        Object indentStr = "";
        for (int i = 0; i < indent; ++i) {
            indentStr = (String)indentStr + " ";
        }
        if (((String)ret).isEmpty() && indent == 0) {
            ret = "Document\n";
        }
        for (AttrData attr : this.attributeByList) {
            ArrayList<DataObjectAttribute> meta = Metadata.get(this.qualName);
            Enum type = null;
            for (int i = 0; i < meta.size() && type == null; ++i) {
                if (!meta.get((int)i).name.equals(attr.name)) continue;
                type = meta.get((int)i).type;
            }
            if (type == DataObjectAttribute.DataType.OBJECT) {
                ArrayList objs = (ArrayList)attr.value;
                int i = 0;
                for (DocumentDataObject obj : objs) {
                    ret = (String)ret + (String)indentStr + obj.qualName + "[" + i + "]\n";
                    ret = (String)ret + obj.showDoc(indent + 2, i++);
                }
                continue;
            }
            ret = (String)ret + (String)indentStr + this.qualName + "[" + index + "]." + attr.name + " {" + type.toString() + "} value = \"" + String.valueOf(attr.value) + "\"\n";
        }
        return ret;
    }

    private class AttrData {
        String name;
        Object value;

        AttrData(String a_name, Object a_value) {
            this.name = a_name;
            this.value = a_value;
        }
    }
}

