/*
 * Decompiled with CFR 0.152.
 */
package org.bluesky.blueprint.logger;

import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import org.bluesky.blueprint.base.BluePrintException;
import org.bluesky.blueprint.base.Logger;

public class SimpleFileLogger
extends Logger {
    private HashMap<String, FileWriter> tags;

    public SimpleFileLogger(Properties props) throws BluePrintException {
        super(props);
        String defString = props.getProperty("logger.file.tags", "ALL");
        defString = defString.replace("ALL", "INFO,DEBUG,ERROR");
        this.tags = new HashMap();
        String filename = props.getProperty("logger.file.default.loc");
        filename = filename.replace("{TS}", new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
        try {
            FileWriter defFile = new FileWriter(filename, true);
            for (String tag : defString.split(",")) {
                this.addFileForTag(props, defFile, tag);
            }
        }
        catch (IOException e) {
            throw new BluePrintException("Cannot create log file with filename " + filename + " due to exception " + e.getMessage());
        }
    }

    private void addFileForTag(Properties prop, FileWriter defFile, String tag) throws BluePrintException {
        String filename = prop.getProperty("logger.file." + tag + ".loc");
        FileWriter file = null;
        if (filename != null) {
            filename = filename.replace("{TS}", new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
            try {
                file = new FileWriter(filename, true);
            }
            catch (IOException e) {
                throw new BluePrintException("Cannot create log file with filename " + filename + " due to exception " + e.getMessage());
            }
        } else {
            file = defFile;
        }
        this.tags.put(tag, file);
    }

    @Override
    public void log(String message) {
        block4: {
            FileWriter f = this.tags.get("INFO");
            if (f != null) {
                try {
                    f.append("[" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()) + "][INFO] " + message + "\n");
                    f.flush();
                }
                catch (Exception e) {
                    if (this.next == null) break block4;
                    this.next.error("Failed to write to INFO log file ");
                }
            }
        }
        if (this.next != null) {
            this.next.log(message);
        }
    }

    @Override
    public void debug(String message) {
        block4: {
            FileWriter f = this.tags.get("DEBUG");
            if (f != null) {
                try {
                    f.append("[" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()) + "][DEBUG] " + message + "\n");
                    f.flush();
                }
                catch (Exception e) {
                    if (this.next == null) break block4;
                    this.next.error("Failed to write to DEBUG log file ");
                }
            }
        }
        if (this.next != null) {
            this.next.debug(message);
        }
    }

    @Override
    public void error(String message) {
        block4: {
            FileWriter f = this.tags.get("ERROR");
            if (f != null) {
                try {
                    f.append("[" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()) + "][ERROR] " + message + "\n");
                    f.flush();
                }
                catch (Exception e) {
                    if (this.next == null) break block4;
                    this.next.error("Failed to write to ERROR log file ");
                }
            }
        }
        if (this.next != null) {
            this.next.error(message);
        }
    }

    @Override
    public void logWithTag(String tag, String message) {
        block4: {
            FileWriter f = this.tags.get(tag);
            if (f != null) {
                try {
                    f.append("[" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()) + "][" + tag + "] " + message + "\n");
                    f.flush();
                }
                catch (Exception e) {
                    if (this.next == null) break block4;
                    this.next.error("Failed to write to " + tag + " log file ");
                }
            }
        }
        if (this.next != null) {
            this.next.logWithTag(tag, message);
        }
    }
}

