/*
 * Decompiled with CFR 0.152.
 */
package org.bluesky.blueprint.security.authentication;

import java.util.ArrayList;
import org.bluesky.blueprint.base.Request;
import org.bluesky.blueprint.base.Service;
import org.bluesky.blueprint.security.authentication.AuthContext;
import org.bluesky.blueprint.security.authentication.AuthRequest;

public class AuthLdapClient {
    private Service service;

    public AuthLdapClient(Service a_service) {
        this.service = a_service;
    }

    public ArrayList<String> getLdapGroups(String ldapDomain, AuthContext ac) throws Exception {
        ArrayList<String> ret = null;
        if (ac == null) {
            ac = new AuthContext();
        }
        ac.domain = ldapDomain;
        AuthRequest ar = new AuthRequest("GetLdapGroups", this.service);
        ar.addContext(ac);
        this.service.request(ar);
        this.service.response(ar.getID());
        if (ar.getStatus() == Request.Status.FAULT) {
            throw ar.getFaultException();
        }
        ret = ac.groups;
        return ret;
    }

    public String Authenticate(String ldapDomain, AuthContext ac) throws Exception {
        String ret = "";
        if (ac == null) {
            ac = new AuthContext();
        }
        ac.domain = ldapDomain;
        AuthRequest ar = new AuthRequest("LdapAuthenticate", this.service);
        ar.addContext(ac);
        this.service.request(ar);
        this.service.response(ar.getID());
        if (ar.getStatus() == Request.Status.FAULT) {
            throw ar.getFaultException();
        }
        ret = ac.token;
        return ret;
    }

    public AuthContext Authenticate(String ldapDomain, String username, String password) throws Exception {
        AuthContext ac = new AuthContext();
        ac.domain = ldapDomain;
        ac.username = username;
        ac.password = password;
        AuthRequest ar = new AuthRequest("LdapAuthenticate", this.service);
        ar.addContext(ac);
        this.service.request(ar);
        this.service.response(ar.getID());
        if (ar.getStatus() == Request.Status.FAULT) {
            throw ar.getFaultException();
        }
        return ac;
    }

    public ArrayList<String> getLdapUserGroups(String ldapDomain, String username, AuthContext ac) throws Exception {
        ArrayList<String> ret = null;
        if (ac == null) {
            ac = new AuthContext();
        }
        ac.domain = ldapDomain;
        ac.username = username;
        AuthRequest ar = new AuthRequest("GetLdapUserGroups", this.service);
        ar.addContext(ac);
        this.service.request(ar);
        this.service.response(ar.getID());
        if (ar.getStatus() == Request.Status.FAULT) {
            throw ar.getFaultException();
        }
        ret = ac.groups;
        return ret;
    }
}

