/*
 * Decompiled with CFR 0.152.
 */
package org.bluesky.blueprint.security.authentication;

import org.bluesky.blueprint.base.BluePrintException;
import org.bluesky.blueprint.base.Container;
import org.bluesky.blueprint.base.OPTYPE;
import org.bluesky.blueprint.base.Request;
import org.bluesky.blueprint.base.Service;
import org.bluesky.blueprint.security.authentication.AuthContext;

public class AuthPasscodeService
extends Service {
    private int passcode = Integer.parseInt(Container.getAppProperties().getProperty("auth.passcode.value"));
    private String loginService = Container.getAppProperties().getProperty("auth.passcode.service");

    public AuthPasscodeService(Container a_owner) {
        super("PasscodeAuthenticate", a_owner);
    }

    @Override
    public void doWork(Request _request) throws Exception {
        AuthContext ac = (AuthContext)_request.getContext(OPTYPE.SECURITY);
        if (ac == null) {
            throw new BluePrintException("No AuthContext in request for passcode authentication");
        }
        if (ac.password.isEmpty()) {
            ac.authUrl = this.loginService;
        } else {
            ac.authenticated = ac.password.hashCode() == this.passcode;
        }
    }
}

