/*
 * Decompiled with CFR 0.152.
 */
package org.bluesky.blueprint.web;

import java.net.URI;
import java.util.HashMap;
import java.util.Stack;
import java.util.UUID;
import org.bluesky.blueprint.security.authentication.AuthContext;

public class Session {
    private UUID sessionID = UUID.randomUUID();
    private HashMap<String, Object> items;
    private Stack<URI> navhistory;
    private AuthContext authentication = null;
    private static HashMap<UUID, Session> cache = new HashMap();

    public Session() {
        cache.put(this.sessionID, this);
        this.items = new HashMap();
        this.navhistory = new Stack();
    }

    public void pushPage(URI a_uri) {
        this.navhistory.push(a_uri);
    }

    public URI popPage() {
        return this.navhistory.pop();
    }

    public void addItem(String a_key, Object a_item) {
        this.items.put(a_key, a_item);
    }

    public Object getItem(String a_key) {
        return this.items.get(a_key);
    }

    public Object removeItem(String a_key) {
        return this.items.remove(a_key);
    }

    public static Session getSession(UUID a_id) {
        return cache.get(a_id);
    }

    public static Session openSession(UUID a_id) {
        return new Session();
    }

    public void closeSession(Session a_session) {
        cache.remove(a_session.sessionID);
    }

    public UUID getID() {
        return this.sessionID;
    }

    public HashMap<String, Object> getItems() {
        return this.items;
    }

    public Stack<URI> getNavHistory() {
        return this.navhistory;
    }

    public AuthContext getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(AuthContext authentication) {
        this.authentication = authentication;
    }
}

