/*
 * Decompiled with CFR 0.152.
 */
package org.bluesky.blueprint.web;

import com.sun.net.httpserver.Headers;
import java.io.IOException;
import org.bluesky.blueprint.base.Container;
import org.bluesky.blueprint.base.OPTYPE;
import org.bluesky.blueprint.base.Request;
import org.bluesky.blueprint.base.Service;
import org.bluesky.blueprint.web.WebContext;

public class WebAPIMainService
extends Service {
    protected String sroot = "API";
    protected String uroot = "/api/";

    public WebAPIMainService(Container a_owner) {
        super("MainAPI", a_owner);
    }

    @Override
    public void doWork(Request a_request) throws Exception {
        WebContext c = (WebContext)a_request.getContext(OPTYPE.WEB);
        c.responseMime = "application/json";
        System.out.println(c.getServiceString());
        System.out.println(c.getVerb());
        if (!c.getVerb().equals("OPTIONS")) {
            String serviceName = this.sroot + c.getServiceString().replace(this.uroot, "");
            serviceName = serviceName.indexOf(47) > -1 ? serviceName.substring(0, serviceName.indexOf(47)) + c.getVerb() : serviceName + c.getVerb();
            Request request = serviceName.startsWith(this.sroot + "data") ? new Request(OPTYPE.WEBDATA, this.owner.getDomain(), serviceName, this) : new Request(OPTYPE.WEB, this.owner.getDomain(), serviceName, this);
            System.out.println(serviceName);
            request.addContext(c);
            try {
                long rid = this.request(request);
                this.response(rid);
                if (request.getStatus() == Request.Status.RESPONSE) {
                    if (c.responseCode == 0) {
                        c.responseCode = 200;
                    }
                } else {
                    throw request.getFaultException();
                }
                Container.getLogger().debug("Successful execution of service " + c.getContextString() + "/" + c.getServiceString() + " with return code " + c.responseCode);
            }
            catch (Exception e) {
                c.responseCode = 500;
                c.responseMime = "application/json";
                c.response = ("{ Error:  '" + e.getMessage() + "'}").getBytes();
                Container.getLogger().error("Unsuccessful execution of service " + c.getContextString() + c.getServiceString() + " with return code " + c.responseCode);
            }
        } else {
            c.responseCode = 200;
            c.responseMime = "application/x-www-form-urlencoded";
        }
        Headers responseHeaders = c.exchange.getResponseHeaders();
        responseHeaders.set("Content-Type", c.responseMime);
        responseHeaders.set("Access-Control-Allow-Origin", "*");
        responseHeaders.set("Access-Control-Allow-Methods", "POST, GET, OPTIONS");
        responseHeaders.set("Access-Control-Allow-Headers", "X-PINGOTHER, Content-Type");
        responseHeaders.set("Access-Control-Max-Age", "86400");
        try {
            c.exchange.sendResponseHeaders(c.responseCode, 0L);
            c.exchange.getResponseBody().write(c.response);
            c.exchange.getResponseBody().flush();
            c.exchange.getResponseBody().close();
        }
        catch (IOException e) {
            Container.getLogger().error("Error sending Page response " + e.getLocalizedMessage());
            throw e;
        }
    }
}

