/*
 * Decompiled with CFR 0.152.
 */
package org.bluesky.blueprint.web;

import com.sun.net.httpserver.HttpExchange;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import org.bluesky.blueprint.base.Context;
import org.bluesky.blueprint.base.OPTYPE;
import org.bluesky.blueprint.web.Session;

public class WebContext
extends Context {
    public HttpExchange exchange = null;
    public Session session = null;
    public byte[] response = null;
    public int responseCode;
    public String responseMime;
    public String redirect = null;
    public String source = null;
    private HashMap<String, String> parameters = null;
    private HashMap<String, String> reqParameters = null;

    public WebContext() {
        super(OPTYPE.WEB);
    }

    public String getContextString() {
        return this.exchange.getHttpContext().getPath();
    }

    public String getServiceString() {
        String ret = "";
        ret = this.redirect != null ? this.redirect : this.exchange.getRequestURI().getPath().replace(this.getContextString(), "");
        return ret;
    }

    public String getResourceString(String a_container) {
        int con_end = this.exchange.getRequestURI().getPath().indexOf(a_container + "/");
        return this.exchange.getRequestURI().getPath().substring(con_end += a_container.length() + 1);
    }

    public String getVerb() {
        return this.exchange.getRequestMethod();
    }

    public HashMap<String, String> getParameters() {
        if (this.parameters == null) {
            this.parameters = new HashMap();
            if (this.exchange.getRequestURI().getQuery() != null) {
                String pars = null;
                try {
                    String[] pairs;
                    pars = URLDecoder.decode(this.exchange.getRequestURI().getQuery(), "UTF-8");
                    for (String s2 : pairs = pars.split("&")) {
                        String[] parts = s2.split("=");
                        if (parts.length != 2) continue;
                        this.parameters.put(parts[0], parts[1]);
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
        }
        return this.parameters;
    }

    public HashMap<String, String> getRequestParameters() {
        if (this.reqParameters == null) {
            this.reqParameters = new HashMap();
            String pars = null;
            try {
                String[] pairs;
                pars = URLDecoder.decode(new String(this.exchange.getRequestBody().readAllBytes()), "UTF-8");
                for (String s2 : pairs = pars.split("&")) {
                    String[] parts = s2.split("=");
                    if (parts.length != 2) continue;
                    this.reqParameters.put(parts[0], parts[1]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.reqParameters;
    }

    public String getRedirect() {
        return this.redirect;
    }

    public void setRedirect(String redirect) {
        this.redirect = redirect;
    }
}

