/*
 * Decompiled with CFR 0.152.
 */
package org.bluesky.blueprint.web;

import org.bluesky.blueprint.base.Container;
import org.bluesky.blueprint.base.OPTYPE;
import org.bluesky.blueprint.base.Request;
import org.bluesky.blueprint.base.Service;
import org.bluesky.blueprint.file.FileClient;
import org.bluesky.blueprint.web.WebContext;

public class WebPageWrapperService
extends Service {
    private String fileCache = null;
    private int respCode;
    private String location;
    private String page;

    public WebPageWrapperService(Container a_owner, String a_name, String a_loc, String a_page) {
        super("App" + a_name, a_owner);
        this.location = a_loc;
        this.page = a_page;
    }

    @Override
    public void doWork(Request a_request) throws Exception {
        WebContext c = (WebContext)a_request.getContext(OPTYPE.WEB);
        if (this.fileCache == null) {
            try {
                this.fileCache = new FileClient(this).readTextFile(this.location, this.page, null);
                this.respCode = 200;
            }
            catch (Exception e) {
                this.fileCache = "<html><h1>404 - Page not found</h1></html>";
                this.respCode = 404;
            }
        }
        if (c != null) {
            c.responseCode = this.respCode;
            c.response = this.fileCache.getBytes();
        } else {
            Container.getLogger().error("Missing Context for PAGE webService " + this.subType);
        }
    }
}

