/*
 * Decompiled with CFR 0.152.
 */
package org.bluesky.blueprint.web.data;

import java.util.ArrayList;
import org.bluesky.blueprint.base.BluePrintException;
import org.bluesky.blueprint.base.Container;
import org.bluesky.blueprint.base.OPTYPE;
import org.bluesky.blueprint.base.Request;
import org.bluesky.blueprint.base.Service;
import org.bluesky.blueprint.data.DataClient;
import org.bluesky.blueprint.data.DataObject;
import org.bluesky.blueprint.data.DataObjectAttribute;
import org.bluesky.blueprint.web.WebContext;
import org.bluesky.blueprint.web.data.WebDataContainer;

public class WebDataFetchService
extends Service {
    private DataClient dc = new DataClient(this);

    public WebDataFetchService(Container a_owner) {
        super("APIdataGET", a_owner);
    }

    @Override
    public void doWork(Request _request) throws Exception {
        WebContext wc = (WebContext)_request.getContext(OPTYPE.WEB);
        Object response = "";
        if (wc == null) {
            throw new BluePrintException("No Web Context for WebData Fetch");
        }
        String url = wc.exchange.getRequestURI().getPath();
        String[] parts = (url = url.substring(url.lastIndexOf("/data/") + 6)).split("/");
        if (parts.length == 2) {
            DataObject obj = ((WebDataContainer)this.owner).getDataObject(parts[0]).CreateDataObject(parts[1]);
            try {
                this.dc.FetchDataObject(obj, null);
            }
            catch (Exception e) {
                throw new BluePrintException("Could not fetch object of type " + parts[0] + " with PBID of " + parts[1]);
            }
            response = this.dataObjectToJson(obj);
        } else if (parts.length == 1) {
            DataObject obj = ((WebDataContainer)this.owner).getDataObject(parts[0]);
            if (obj == null) {
                throw new BluePrintException("Unknow Data Object in url ");
            }
            ArrayList<DataObject> objs = this.dc.FetchManyDataObjects(obj, null);
            for (DataObject d : objs) {
                response = ((String)response).isEmpty() ? "{[\n" : (String)response + ",\n";
                response = (String)response + this.dataObjectToJson(d);
            }
            response = (String)response + "]}";
        } else {
            throw new BluePrintException("Malford URL " + wc.exchange.getRequestURI().getPath() + " for WebData Fetch");
        }
        wc.responseCode = 200;
        wc.responseMime = "application/json";
        wc.response = ((String)response).getBytes();
    }

    private String dataObjectToJson(DataObject a_obj) {
        Object json = "{\n";
        json = (String)json + "\t\"classname\" : \"" + a_obj.getName() + "\",\n";
        json = (String)json + "\t\"PBID\" : \"" + a_obj.getBPID() + "\",\n";
        block3: for (DataObjectAttribute attr : a_obj.getAttributeMetaData()) {
            switch (attr.type) {
                case INTEGER: 
                case FLOAT: {
                    json = (String)json + "\t\"" + attr.name + "\" : " + String.valueOf(a_obj.getAttribute(attr.name)) + ",\n";
                    continue block3;
                }
            }
            json = (String)json + "\t\"" + attr.name + "\" : \"" + String.valueOf(a_obj.getAttribute(attr.name)) + "\",\n";
        }
        json = (String)json + "}";
        return json;
    }
}

