/*
 * Decompiled with CFR 0.152.
 */
package com.bluesky.clearsky;

import com.bluesky.clearsky.data.LocationDataObject;
import com.bluesky.clearsky.data.MobileSQMDataObject;
import com.bluesky.clearsky.data.MobileSQMReadingDataObject;
import com.bluesky.clearsky.data.ObservatorySQMReadingDataObject;
import com.bluesky.clearsky.jobs.StaticSQMLoadJob;
import com.bluesky.clearsky.web.DataEntryService;
import com.bluesky.clearsky.web.LocationsService;
import com.bluesky.clearsky.web.PortalService;
import com.bluesky.clearsky.web.SQMCLocationService;
import com.bluesky.clearsky.web.SQMChangeService;
import com.bluesky.clearsky.web.SQMResultsService;
import com.bluesky.clearsky.web.StaticResultsService;
import com.bluesky.clearsky.web.StaticTrendService;
import com.sun.net.httpserver.HttpServer;
import java.net.InetSocketAddress;
import java.util.Date;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.bluesky.blueprint.analysis.AnalysisContainer;
import org.bluesky.blueprint.analysis.AnalysisRunPostgresQuery;
import org.bluesky.blueprint.base.Container;
import org.bluesky.blueprint.base.Service;
import org.bluesky.blueprint.data.DataObject;
import org.bluesky.blueprint.data.postgres.DataContainerPostgres;
import org.bluesky.blueprint.file.FileContainer;
import org.bluesky.blueprint.job.Job;
import org.bluesky.blueprint.job.JobClient;
import org.bluesky.blueprint.job.JobContainer;
import org.bluesky.blueprint.job.JobSpec;
import org.bluesky.blueprint.monitor.MonitorContainer;
import org.bluesky.blueprint.security.authentication.AuthPasscodeContainer;
import org.bluesky.blueprint.web.WebContainer;
import org.bluesky.blueprint.web.WebResourceMainService;
import org.bluesky.blueprint.web.data.WebDataContainer;

public class RunAppServer {
    public static void main(String[] args) {
        String dataDomain = null;
        String dataUrl = null;
        String dataUsrname = null;
        String filePagesloc = null;
        int webPort = 0;
        int dataPoolSize = 0;
        int dataOperators = 0;
        int fileOperators = 0;
        int jobInterval = 0;
        String jobDir = null;
        String propfile = "clearsky/blueprint.properties";
        try {
            Container.loadProperties((String)propfile);
            dataDomain = Container.getAppProperties().getProperty("data.domain");
            dataUrl = Container.getAppProperties().getProperty("data.url");
            dataUsrname = Container.getAppProperties().getProperty("data.usrname");
            filePagesloc = Container.getAppProperties().getProperty("file.pagesloc");
            webPort = Integer.parseInt(Container.getAppProperties().getProperty("web.port"));
            dataPoolSize = Integer.parseInt(Container.getAppProperties().getProperty("data.poolsize"));
            dataOperators = Integer.parseInt(Container.getAppProperties().getProperty("data.operators"));
            fileOperators = Integer.parseInt(Container.getAppProperties().getProperty("file.operators"));
            jobInterval = Integer.parseInt(Container.getAppProperties().getProperty("job.staticload.interval"));
            jobDir = Container.getAppProperties().getProperty("job.staticload.filedir");
            if (!Container.getAppProperties().containsKey("app.passcode")) {
                Container.getAppProperties().setProperty("app.passcode", Integer.toString("clearsky".hashCode()));
                Container.saveProperties();
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage() + " Exiting");
            System.exit(1);
        }
        Container.setLogger();
        Container.getLogger().log("Starting in Directory " + System.getProperty("user.dir"));
        InetSocketAddress addr = new InetSocketAddress(webPort);
        try {
            HttpServer hserv = HttpServer.create(addr, 0);
            hserv.setExecutor(Executors.newCachedThreadPool());
            new MonitorContainer(3, hserv);
            WebContainer wc = new WebContainer("darksky", 10, hserv);
            wc.addService((Service)new DataEntryService((Container)wc));
            wc.addService((Service)new PortalService((Container)wc));
            wc.addService((Service)new SQMChangeService((Container)wc));
            wc.addService((Service)new SQMResultsService((Container)wc));
            wc.addService((Service)new LocationsService((Container)wc));
            wc.addService((Service)new SQMCLocationService((Container)wc));
            wc.addService((Service)new StaticResultsService((Container)wc));
            wc.addService((Service)new StaticTrendService((Container)wc));
            ((WebResourceMainService)wc.getResourceManager()).addResourceMap("SQM-DataGatheringSheet-02.pdf", filePagesloc + "/docs/SQM-DataGatheringSheet-02.pdf");
            ((WebResourceMainService)wc.getResourceManager()).addResourceMap("SQM-Project-Instructions-02.pdf", filePagesloc + "/docs/SQM-Project-Instructions-02.pdf");
            hserv.start();
            DataContainerPostgres dpc = new DataContainerPostgres(dataDomain, dataOperators);
            dpc.setup(dataUrl, dataUsrname, dataUsrname, dataPoolSize);
            if (dpc.createTable((DataObject)new LocationDataObject())) {
                dpc.insertObject((DataObject)new LocationDataObject(10, "Marlborough Area - Town Hall", "Marlborough Town Hall", "reacting.feasted.emphasis", "51.42129", "-1.73008"));
                dpc.insertObject((DataObject)new LocationDataObject(11, "Marlborough Area - Silbury Hill", "Silbury Hill car Park", "proof.hill.pianists", "51.41636", "-1.8624"));
                dpc.insertObject((DataObject)new LocationDataObject(12, "Marlborough Area - Avebury", "Avebury Red Lion car park", "exam.piper.lightbulb", "51.42884", "-1.85443"));
                dpc.insertObject((DataObject)new LocationDataObject(13, "Marlborough Area - Hackpen Hill", "Hackpen hill car park", "ties.judge.pints", "51.47153", "-1.81529"));
                dpc.insertObject((DataObject)new LocationDataObject(14, "Marlborough Area - Rocklet traingle", "Rocklet traingle ( Og Maisey/Hackpen Rd junction)", "bloodshot.absorb.partly", "51.44272", "-1.76002"));
                dpc.insertObject((DataObject)new LocationDataObject(20, "Newbury Area - Gangbridge Lane", "Gangbridge Lane,Stoke", "minimum.stubborn.changes", "51.26072", "-1.41678"));
                dpc.insertObject((DataObject)new LocationDataObject(21, "Newbury Area - East Woodhay", "East Woodhay Village Hall", "ratio.stack.that", "51.35707", "-1.40738"));
                dpc.insertObject((DataObject)new LocationDataObject(22, "Newbury Area - Ashmansworth", "Ashmansworth Village", "subway.wreck.embellish", "51.31483", "-1.40590"));
                dpc.insertObject((DataObject)new LocationDataObject(23, "Newbury Area - Linkenholt", "Linkenholt", "research.steady.highly", "51.32582", "-1.46709"));
                dpc.insertObject((DataObject)new LocationDataObject(30, "Swindon Area - Pack Hill", "Pack Hill Layby, Wanborough", "moods.scores.looks", "51.54152", "-1.71998"));
                dpc.insertObject((DataObject)new LocationDataObject(31, "Swindon Area - Horpit", "Horpit Layby, Wanborough", "brush.haunts.untruth", "51.55346", "-1.70085"));
                dpc.insertObject((DataObject)new LocationDataObject(32, "Swindon Area - Ashbury Cenotaph", "Cenotaph, Chapel Lane, Ashbury", "munched.assist.beads", "51.56389", "-1.62038"));
                dpc.insertObject((DataObject)new LocationDataObject(33, "Swindon Area - Ashdown House", "Driveway to Ashdown House & Estate car park (NT)", "enrolling.famous.divides", "51.53909", "-1.59099"));
                dpc.insertObject((DataObject)new LocationDataObject(40, "Devizes Area - Alton Barnes", "Alton Barnes", "crowd.rationed.crouch", "51.372911", "-1.83465"));
                dpc.insertObject((DataObject)new LocationDataObject(41, "Devizes Area - All Cannings", "All Cannings", "outbursts.movie.describes", "51.356606", "-1.896783"));
                dpc.insertObject((DataObject)new LocationDataObject(42, "Devizes Area - Bishops Cannings", "Bishops Cannings", "vague.unwraps.blitz", "51.376469", "-1.94742"));
                dpc.insertObject((DataObject)new LocationDataObject(43, "Devizes Area - NE Devizes", "NE Devizes", "compounds.recorders.december", "51.364988", " -1.97459"));
                dpc.insertObject((DataObject)new LocationDataObject(44, "Devizes Area - Buttle Farm", "Buttle Farm, Compton Bassett", "ember.flushed.lavished", "51.445087", "-1.958528"));
                dpc.insertObject((DataObject)new LocationDataObject(50, "Collingbourne Area - Great Bedwyn", "Canal Car Park", "gems.employ.exposes", "51.378221", "-1.598369"));
                dpc.insertObject((DataObject)new LocationDataObject(51, "Collingbourne Area - Wilton", "Windmill Layby", "clothed.cloud.tilts", "51.353965", "-1.604944"));
                dpc.insertObject((DataObject)new LocationDataObject(52, "Collingbourne Area - Ludgershall", "Lovell Homes Site Entrance", "copper.logged.musically", "51.258180", "-1.632777"));
                dpc.insertObject((DataObject)new LocationDataObject(53, "Collingbourne Area - Kingston", "Barleycorn Inn Car Park", "cleanest.admiringly.foggy", "51.300385", "-1.659226"));
                dpc.insertObject((DataObject)new LocationDataObject(54, "Collingbourne Area - Bruces Cottage", "Pestell Shed Garden", "steadier.minds.installs", "51.347469", "-1.716343"));
                dpc.insertObject((DataObject)new LocationDataObject(60, "Lambourn area - Lambourn Woodlands Industrial Estate", "Orange metal post on LHS of entrance road", "skinny.establish.alerting", "51.47713", "-1.55226"));
                dpc.insertObject((DataObject)new LocationDataObject(61, "Lambourn area - Baydon Motorway Bridge", "Middle of road bridge - west side", "woke.relocated.select", "51.50575", "-1.59658"));
                dpc.insertObject((DataObject)new LocationDataObject(62, "Lambourn area - Sheepdrove Red Barn", "Wooden 5 bar gate", "blast.swoop.tasters", "51.53279", "-1.49894"));
            }
            if (dpc.createTable((DataObject)new MobileSQMDataObject())) {
                dpc.insertObject((DataObject)new MobileSQMDataObject(1, "MCBO1-0316", "Assigned"));
                dpc.insertObject((DataObject)new MobileSQMDataObject(2, "NWD1-1C97", "Assigned"));
                dpc.insertObject((DataObject)new MobileSQMDataObject(3, "NWD2-1d2E", "Assigned"));
                dpc.insertObject((DataObject)new MobileSQMDataObject(4, "NWD3-1EF9", "Assigned"));
                dpc.insertObject((DataObject)new MobileSQMDataObject(5, "NWD4-1F06", "Assigned"));
                dpc.insertObject((DataObject)new MobileSQMDataObject(6, "NWD5-1F1C", "Assigned"));
            }
            dpc.createTable((DataObject)new MobileSQMReadingDataObject());
            dpc.createTable((DataObject)new ObservatorySQMReadingDataObject());
            FileContainer fc = new FileContainer(fileOperators);
            fc.addFileLocMap("pages", filePagesloc);
            fc.addFileLocMap("analysis", filePagesloc + "/analysis");
            fc.addFileLocMap("BPpages", filePagesloc);
            WebDataContainer wdc = new WebDataContainer(4);
            wdc.registerDataObject((DataObject)new LocationDataObject());
            wdc.registerDataObject((DataObject)new MobileSQMDataObject());
            AuthPasscodeContainer apc = new AuthPasscodeContainer(1);
            AnalysisContainer anc = new AnalysisContainer(4);
            anc.addService((Service)new AnalysisRunPostgresQuery((Container)anc, dpc));
            JobContainer jc = new JobContainer(2, 2);
            Properties jp = new Properties();
            jp.setProperty("DataDir", jobDir);
            JobSpec js = new JobSpec(JobSpec.Type.RATE, "Static SQM Data Loader", new Date(), jobInterval, TimeUnit.MINUTES, jp);
            Container.getLogger().log("Dark Sky Server Started");
            JobClient jcli = new JobClient(jc.getBackgroundService());
            jcli.startJob((Job)new StaticSQMLoadJob(js), null);
            Container.getLogger().log("Started SQM Load Job");
        }
        catch (Exception e) {
            Container.getLogger().error("Error starting Server: " + e.getMessage());
        }
    }
}

