/*
 * Decompiled with CFR 0.152.
 */
package com.bluesky.clearsky.jobs;

import com.bluesky.clearsky.data.ObservatorySQMReadingDataObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import org.bluesky.blueprint.data.DataClient;
import org.bluesky.blueprint.data.DataObject;
import org.bluesky.blueprint.job.Job;
import org.bluesky.blueprint.job.JobContainer;
import org.bluesky.blueprint.job.JobSpec;

public class StaticSQMLoadJob
extends Job {
    public StaticSQMLoadJob(JobSpec a_spec) {
        super(a_spec);
    }

    public boolean doWork() {
        String dir = this.spec.getParameters().getProperty("DataDir");
        boolean ret = true;
        this.status.message = "Starting";
        File[] files = null;
        try {
            files = new File(dir).listFiles();
        }
        catch (Exception e) {
            this.status.message = "Failed to get directory listing for " + dir;
            ret = false;
        }
        double incPerFile = 100.0 / (double)files.length;
        DataClient dataClient = new DataClient(((JobContainer)this.container).getBackgroundService());
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            try {
                if (!f.isDirectory()) {
                    String line;
                    BufferedReader br = new BufferedReader(new FileReader(f));
                    while ((line = br.readLine()) != null) {
                        if (line.startsWith("Produce") || line.startsWith("Year") || line.isEmpty()) continue;
                        ObservatorySQMReadingDataObject reading = new ObservatorySQMReadingDataObject();
                        reading.populateFromString(line);
                        dataClient.CreateODatabject((DataObject)reading, null);
                    }
                    br.close();
                    f.renameTo(new File(dir + "/processed/" + f.getName()));
                    this.status.message = "Processed file " + f.getAbsolutePath();
                }
                this.status.pct = this.status.pct + incPerFile;
                this.status.message = "Processed " + (files.length - 1) + " files";
            }
            catch (Exception e) {
                this.status.message = "Error loading file " + f.getAbsolutePath() + ": " + e.getMessage();
                ret = false;
            }
            ++n2;
        }
        return ret;
    }
}

