/*
 * Decompiled with CFR 0.152.
 */
package com.bluesky.clearsky.web;

import com.bluesky.clearsky.AnalysisCommon;
import java.util.HashMap;
import org.bluesky.blueprint.analysis.AnalysisClient;
import org.bluesky.blueprint.analysis.AnalysisContext;
import org.bluesky.blueprint.analysis.AnalysisData;
import org.bluesky.blueprint.analysis.AnalysisUtils;
import org.bluesky.blueprint.base.Container;
import org.bluesky.blueprint.base.OPTYPE;
import org.bluesky.blueprint.base.Request;
import org.bluesky.blueprint.base.Service;
import org.bluesky.blueprint.file.FileClient;
import org.bluesky.blueprint.web.WebContext;

public class SQMResultsService
extends Service {
    private String page = null;
    private String content = "<table><tr><td span=2>{Graph}</td><td>{key}</td></tr><tr><td colspan=2>{data}</td></tr></table>";
    private String select;

    public SQMResultsService(Container a_owner) {
        super("AppSQMResults", a_owner);
    }

    public void doWork(Request a_request) throws Exception {
        WebContext c = (WebContext)a_request.getContext(OPTYPE.WEB);
        c.responseCode = 200;
        try {
            this.page = new FileClient((Service)this).readTextFile("pages", "pagewithhome.html", null);
            this.page = this.page.replace("{pagename}", "SQM Data Results by Bortle");
            AnalysisClient acli = new AnalysisClient((Service)this);
            HashMap<String, Integer> ins = new HashMap<String, Integer>();
            AnalysisContext ac = acli.RunAnalysis("sqmdatelist", ins, null);
            String syear = (String)c.getRequestParameters().get("yearselect");
            String smonth = (String)c.getRequestParameters().get("monthselect");
            int month = 0;
            int year = 0;
            if (ac.analysisData.size() > 0) {
                if (syear != null) {
                    year = Integer.parseInt(syear);
                    month = Integer.parseInt(smonth);
                } else {
                    year = (Integer)((AnalysisData)ac.analysisData.get((Object)"myear")).values.get(0);
                    month = (Integer)((AnalysisData)ac.analysisData.get((Object)"mmonth")).values.get(0);
                }
                this.select = this.buildDateDropDown(ac, year, month);
            }
            ins.put("year", year);
            ins.put("month", month);
            ac = acli.RunAnalysis("sqmresultsmonth", ins, null);
            String body = this.content.replace("{Graph}", this.buildData(ac.analysisData) + ac.renderer);
            body = body.replace("{data}", AnalysisUtils.AnalysisDataToHTMLTable((HashMap)ac.analysisData, (String)"location,mdate,serial_no,mpsas_1,mpsas_2,mpsas_3,mpsas_4,mpsas_5", (String)"Location,Date,SQM,Result 1,Result 2, Result 3, Result 4,Result 5"));
            body = body.replace("{key}", this.getKey());
            body = body.replace("{select}", this.select);
            this.page = this.page.replace("{pagebody}", body);
        }
        catch (Exception e) {
            c.response = "<html><h1>Internal error page could not be rendered</h1></html>".getBytes();
            Container.getLogger().error("SQM Summary page could not load page files with exception: " + e.getMessage());
            c.responseCode = 500;
        }
        if (c.responseCode == 200) {
            c.response = this.page.getBytes();
        }
    }

    private String buildData(HashMap<String, AnalysisData> a_data) {
        Object ret = "<script>\n";
        Object labels = "\tconst labels = [";
        Object data = "\tconst data ={\n\t\tlabels: labels,\n\t\tdatasets: [{pointBackgroundColor: bgcolours, data:[";
        Object colours = "\tconst bgcolours = [";
        boolean first = true;
        int i = 0;
        while (i < ((AnalysisData)a_data.values().toArray()[0]).values.size()) {
            if (first) {
                first = false;
            } else {
                data = (String)data + ", ";
                colours = (String)colours + ", ";
            }
            if (!((String)labels).contains((String)a_data.get((Object)"location").values.get(i))) {
                if (!first) {
                    labels = (String)labels + ", ";
                }
                labels = (String)labels + "\"" + String.valueOf(a_data.get((Object)"location").values.get(i)) + "\"";
            }
            data = (String)data + "{x: \"" + String.valueOf(a_data.get((Object)"location").values.get(i)) + "\", y: " + String.valueOf(a_data.get((Object)"mpsas_1").values.get(i)) + ", r: 7},";
            colours = (String)colours + AnalysisCommon.getBortalColor((Double)a_data.get((Object)"mpsas_1").values.get(i)) + ", ";
            data = (String)data + "{x: \"" + String.valueOf(a_data.get((Object)"location").values.get(i)) + "\", y: " + String.valueOf(a_data.get((Object)"mpsas_2").values.get(i)) + ", r: 7},";
            colours = (String)colours + AnalysisCommon.getBortalColor((Double)a_data.get((Object)"mpsas_2").values.get(i)) + ", ";
            data = (String)data + "{x: \"" + String.valueOf(a_data.get((Object)"location").values.get(i)) + "\", y: " + String.valueOf(a_data.get((Object)"mpsas_3").values.get(i)) + ", r: 7},";
            colours = (String)colours + AnalysisCommon.getBortalColor((Double)a_data.get((Object)"mpsas_3").values.get(i)) + ", ";
            data = (String)data + "{x: \"" + String.valueOf(a_data.get((Object)"location").values.get(i)) + "\", y: " + String.valueOf(a_data.get((Object)"mpsas_4").values.get(i)) + ", r: 7},";
            colours = (String)colours + AnalysisCommon.getBortalColor((Double)a_data.get((Object)"mpsas_4").values.get(i)) + ", ";
            data = (String)data + "{x: \"" + String.valueOf(a_data.get((Object)"location").values.get(i)) + "\", y: " + String.valueOf(a_data.get((Object)"mpsas_5").values.get(i)) + ", r: 7}";
            colours = (String)colours + AnalysisCommon.getBortalColor((Double)a_data.get((Object)"mpsas_5").values.get(i));
            ++i;
        }
        data = (String)data + "\n]}]};";
        labels = (String)labels + "];\n";
        colours = (String)colours + "];\n";
        ret = (String)ret + (String)labels + (String)colours + (String)data + "</script>";
        return ret;
    }

    private String getKey() {
        Object ret = "<table><tr><th>Select Date</th></tr><tr><td>{select}</td></tr><tr><td>  </td></tr></table><table><tr><th>Bortle Key</th></tr>\n";
        int i = 0;
        while (i < AnalysisCommon.bortleText.length) {
            ret = (String)ret + "\t<tr><td style=\"background-color: " + AnalysisCommon.bortleColours[i] + "; color: " + AnalysisCommon.bortleTextColour[i] + "\">" + AnalysisCommon.bortleText[i] + "</td></tr>\n";
            ++i;
        }
        ret = (String)ret + "</table>\n";
        return ret;
    }

    private String buildDateDropDown(AnalysisContext a_ac, int a_year, int a_month) {
        Object years = "";
        Object months = "";
        int i = 0;
        while (i < ((AnalysisData)a_ac.analysisData.values().toArray()[0]).values.size()) {
            Integer year = (Integer)((AnalysisData)a_ac.analysisData.get((Object)"myear")).values.get(i);
            Integer month = (Integer)((AnalysisData)a_ac.analysisData.get((Object)"mmonth")).values.get(i);
            if (!((String)years).contains(year.toString())) {
                years = year == a_year ? (String)years + "\t<option value=\"" + String.valueOf(year) + "\" selected=true >" + String.valueOf(year) + "</option>\n" : (String)years + "\t<option value=\"" + String.valueOf(year) + "\" >" + String.valueOf(year) + "</option>\n";
            }
            if (year == a_year && !((String)months).contains(AnalysisCommon.months[month - 1])) {
                months = month == a_month ? (String)months + "\t<option value=\"" + String.valueOf(month) + "\" selected=true >" + AnalysisCommon.months[month - 1] + "</option>\n" : (String)months + "\t<option value=\"" + String.valueOf(month) + "\" >" + AnalysisCommon.months[month - 1] + "</option>\n";
            }
            ++i;
        }
        String ret = a_ac.renderer.replace("{years}", (CharSequence)years);
        ret = ret.replace("{months}", (CharSequence)months);
        return ret;
    }
}

