/*
 * Decompiled with CFR 0.152.
 */
package org.bluesky.blueprint.analysis;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Time;
import java.sql.Timestamp;
import org.bluesky.blueprint.analysis.AnalysisContext;
import org.bluesky.blueprint.analysis.AnalysisData;
import org.bluesky.blueprint.analysis.AnalysisRequest;
import org.bluesky.blueprint.base.BluePrintException;
import org.bluesky.blueprint.base.Container;
import org.bluesky.blueprint.base.OPTYPE;
import org.bluesky.blueprint.base.Request;
import org.bluesky.blueprint.base.Service;
import org.bluesky.blueprint.data.postgres.DataContainerPostgres;

public class AnalysisRunPostgresQuery
extends Service {
    private DataContainerPostgres dataSource;

    public AnalysisRunPostgresQuery(Container a_owner, DataContainerPostgres a_dataSource) {
        super("RunPostgresQuery", a_owner);
        this.dataSource = a_dataSource;
    }

    @Override
    public void doWork(Request a_request) throws Exception {
        AnalysisRequest ar = (AnalysisRequest)a_request;
        AnalysisContext ac = (AnalysisContext)a_request.getContext(OPTYPE.ANALYSIS);
        String sql = ar.getConfigParameters().get("sql");
        Connection conn = null;
        if (sql != null) {
            try {
                conn = this.dataSource.getConnection();
                PreparedStatement stmt = conn.prepareStatement(sql);
                int col = 0;
                for (AnalysisData ad : ac.inParameters) {
                    ++col;
                    switch (ad.type) {
                        case STRING: {
                            stmt.setString(col, (String)ad.values.get(0));
                            break;
                        }
                        case INTEGER: {
                            stmt.setInt(col, (Integer)ad.values.get(0));
                            break;
                        }
                        case FLOAT: {
                            stmt.setFloat(col, ((Float)ad.values.get(0)).floatValue());
                            break;
                        }
                        case DATE: {
                            stmt.setDate(col, (Date)ad.values.get(0));
                            break;
                        }
                        case TIME: {
                            stmt.setTime(col, (Time)ad.values.get(0));
                            break;
                        }
                        case TIMESTAMP: {
                            stmt.setTimestamp(col, (Timestamp)ad.values.get(0));
                        }
                    }
                }
                ResultSet rs = stmt.executeQuery();
                while (rs.next()) {
                    for (AnalysisData dp : ac.analysisData.values()) {
                        switch (dp.type) {
                            case STRING: {
                                dp.values.add(rs.getString(dp.name));
                                break;
                            }
                            case INTEGER: {
                                dp.values.add(rs.getInt(dp.name));
                                break;
                            }
                            case FLOAT: {
                                dp.values.add(rs.getDouble(dp.name));
                                break;
                            }
                            case DATE: {
                                dp.values.add(rs.getDate(dp.name));
                                break;
                            }
                            case TIME: {
                                dp.values.add(rs.getTime(dp.name));
                                break;
                            }
                            case TIMESTAMP: {
                                dp.values.add(rs.getTimestamp(dp.name));
                            }
                        }
                    }
                }
                this.dataSource.freeConnection(conn);
            }
            catch (Exception e) {
                if (conn != null) {
                    this.dataSource.freeConnection(conn);
                }
                throw new BluePrintException("Error executing query in RunPostgresQuery " + e.getMessage());
            }
        } else {
            throw new BluePrintException("No SQL defined for request to RunPostgresQuery ");
        }
    }
}

