/*
 * Decompiled with CFR 0.152.
 */
package org.bluesky.blueprint.analysis;

import org.bluesky.blueprint.analysis.AnalysisContext;
import org.bluesky.blueprint.analysis.AnalysisData;
import org.bluesky.blueprint.analysis.AnalysisRequest;
import org.bluesky.blueprint.base.BluePrintException;
import org.bluesky.blueprint.base.Container;
import org.bluesky.blueprint.base.OPTYPE;
import org.bluesky.blueprint.base.Request;
import org.bluesky.blueprint.base.Service;
import org.bluesky.blueprint.file.FileClient;

public class AnalysisRunService
extends Service {
    public AnalysisRunService(Container a_owner) {
        super("RunAnalysis", a_owner);
    }

    @Override
    public void doWork(Request a_request) throws Exception {
        AnalysisRequest ar = (AnalysisRequest)a_request;
        AnalysisContext ac = (AnalysisContext)a_request.getContext(OPTYPE.ANALYSIS);
        String def = "";
        Service callingService = ar.getCallingService();
        try {
            String filename = ar.getAnalysisName() + ".yaml";
            def = new FileClient(this).readTextFile("analysis", filename, null);
        }
        catch (Exception e) {
            throw new BluePrintException("Could location Analysis definiion for analysis " + ar.getAnalysisName() + " error: " + e.getMessage());
        }
        this.processDefinition(def, ar, ac);
        switch (ar.getConfigParameters().get("type")) {
            case "service": {
                ar.setService(ar.getConfigParameters().get("name"));
                ar.setCallingService(this);
                this.request(ar);
                this.response(ar.getID());
                if (ar.getStatus() == Request.Status.FAULT) {
                    throw ar.getFaultException();
                }
                ar.setCallingService(callingService);
                break;
            }
            default: {
                throw new BluePrintException("Inavlid or missing renderer action  " + ar.getRenderParameters().get("type"));
            }
        }
        switch (ar.getRenderParameters().get("type")) {
            case "embedded": {
                ac.renderer = ar.getRenderParameters().get("html");
                break;
            }
            default: {
                throw new BluePrintException("Inavlid or missing renderer action  " + ar.getRenderParameters().get("type"));
            }
        }
    }

    private void processDefinition(String def, AnalysisRequest ar, AnalysisContext ac) throws BluePrintException {
        int l;
        int indent = 0;
        int lastindent = 0;
        String[] lines = def.split("\n");
        for (l = 0; !lines[l].startsWith("---") && l < lines.length; ++l) {
        }
        if (!lines[l].startsWith("---")) {
            throw new BluePrintException("Def file missing start of doc marker");
        }
        ++l;
        while (l < lines.length) {
            if (!(lines[l].isEmpty() || lines[l].isBlank() || lines[l].trim().startsWith("#"))) {
                lastindent = indent;
                indent = 0;
                while (lines[l].charAt(indent) == ' ') {
                    ++indent;
                }
                Object token = "";
                int i = indent;
                while (lines[l].charAt(i) != ':') {
                    token = (String)token + lines[l].charAt(i);
                    ++i;
                }
                token = ((String)token).trim();
                Object value = lines[l].substring(i + 1).trim();
                System.out.println(" Parse yaml token = " + (String)token + " value = " + (String)value);
                switch (token) {
                    case "name": {
                        if (((String)value).equals(ar.getAnalysisName())) break;
                        throw new BluePrintException("Def name does not equal " + ar.getAnalysisName());
                    }
                    case "decscription": {
                        break;
                    }
                    case "out_parameters": {
                        String pname;
                        lastindent = indent;
                        do {
                            if (lines[++l].isEmpty() || lines[l].isBlank()) continue;
                            indent = 0;
                            while (lines[l].charAt(indent) == ' ') {
                                ++indent;
                            }
                            if (lines[l].charAt(indent) != '-') continue;
                            pname = lines[l].substring(indent + 1).trim();
                            ++l;
                            indent = 0;
                            while (lines[l].charAt(indent) == ' ') {
                                ++indent;
                            }
                            token = "";
                            i = indent;
                            while (lines[l].charAt(i) != ':') {
                                token = (String)token + lines[l].charAt(i);
                                ++i;
                            }
                            token = ((String)token).trim();
                            value = lines[l].substring(i + 1).trim();
                            if (((String)token).equals("type")) {
                                System.out.println("out_parameter: " + pname + " of type " + (String)value);
                                switch (value) {
                                    case "string": {
                                        ac.analysisData.put(pname, new AnalysisData(pname, AnalysisData.DataType.STRING));
                                        break;
                                    }
                                    case "integer": {
                                        ac.analysisData.put(pname, new AnalysisData(pname, AnalysisData.DataType.INTEGER));
                                        break;
                                    }
                                    case "float": {
                                        ac.analysisData.put(pname, new AnalysisData(pname, AnalysisData.DataType.FLOAT));
                                        break;
                                    }
                                    case "date": {
                                        ac.analysisData.put(pname, new AnalysisData(pname, AnalysisData.DataType.DATE));
                                        break;
                                    }
                                    case "time": {
                                        ac.analysisData.put(pname, new AnalysisData(pname, AnalysisData.DataType.TIME));
                                        break;
                                    }
                                    case "timestamp": {
                                        ac.analysisData.put(pname, new AnalysisData(pname, AnalysisData.DataType.TIMESTAMP));
                                        break;
                                    }
                                    default: {
                                        throw new BluePrintException("Invalid Data Type " + (String)value + " for out_paramter " + pname);
                                    }
                                }
                                continue;
                            }
                            throw new BluePrintException("Expecting 'type' in for out_parameter but got " + (String)token);
                        } while (!lines[l].isEmpty() && !lines[l].isBlank() && indent != lastindent);
                        break;
                    }
                    case "in_parameters": {
                        String pname;
                        lastindent = indent;
                        do {
                            if (lines[++l].isEmpty() || lines[l].isBlank()) continue;
                            indent = 0;
                            while (lines[l].charAt(indent) == ' ') {
                                ++indent;
                            }
                            if (lines[l].charAt(indent) != '-') continue;
                            pname = lines[l].substring(indent + 1).trim();
                            ++l;
                            indent = 0;
                            while (lines[l].charAt(indent) == ' ') {
                                ++indent;
                            }
                            token = "";
                            i = indent;
                            while (lines[l].charAt(i) != ':') {
                                token = (String)token + lines[l].charAt(i);
                                ++i;
                            }
                            token = ((String)token).trim();
                            value = lines[l].substring(i + 1).trim();
                            if (((String)token).equals("type")) {
                                AnalysisData.DataType dt;
                                System.out.println("in_parameter: " + pname + " of type " + (String)value);
                                switch (value) {
                                    case "string": {
                                        dt = AnalysisData.DataType.STRING;
                                        break;
                                    }
                                    case "integer": {
                                        dt = AnalysisData.DataType.INTEGER;
                                        break;
                                    }
                                    case "float": {
                                        dt = AnalysisData.DataType.FLOAT;
                                        break;
                                    }
                                    case "date": {
                                        dt = AnalysisData.DataType.DATE;
                                        break;
                                    }
                                    case "time": {
                                        dt = AnalysisData.DataType.TIME;
                                        break;
                                    }
                                    case "timestamp": {
                                        dt = AnalysisData.DataType.TIMESTAMP;
                                        break;
                                    }
                                    default: {
                                        throw new BluePrintException("Invalid Data Type " + (String)value + " for out_paramter " + pname);
                                    }
                                }
                                AnalysisData ad = new AnalysisData(pname, dt);
                                ad.values.add(ar.getInParameters().get(pname));
                                ac.inParameters.add(ad);
                                continue;
                            }
                            throw new BluePrintException("Expecting 'type' in for out_parameter but got " + (String)token);
                        } while (!lines[l].isEmpty() && !lines[l].isBlank() && indent != lastindent);
                        break;
                    }
                    case "dataservice": {
                        do {
                            if (lines[++l].isEmpty() || lines[l].isBlank()) continue;
                            indent = 0;
                            while (lines[l].charAt(indent) == ' ') {
                                ++indent;
                            }
                            token = "";
                            i = indent;
                            while (lines[l].charAt(i) != ':') {
                                token = (String)token + lines[l].charAt(i);
                                ++i;
                            }
                            switch (token = ((String)token).trim()) {
                                case "name": 
                                case "type": {
                                    value = lines[l].substring(i + 1).trim();
                                    ar.setConfigParameter((String)token, (String)value);
                                    System.out.println(" dataservice param  = " + (String)token + " value = " + (String)value);
                                    break;
                                }
                                case "sql": {
                                    value = lines[l].substring(i + 1);
                                    while (!lines[l].trim().endsWith("\"")) {
                                        value = (String)value + lines[++l] + "\n";
                                    }
                                    ar.setConfigParameter((String)token, ((String)value).trim().substring(1, ((String)value).length() - 3));
                                    System.out.println(" dataservice param  = " + (String)token + " value = " + (String)value);
                                    break;
                                }
                                default: {
                                    System.err.println("Invalid paramerter " + (String)token + " for dataservice");
                                }
                            }
                        } while (!lines[l].isEmpty() && !lines[l].isBlank() && indent != lastindent);
                        break;
                    }
                    case "renderservice": {
                        do {
                            if (++l >= lines.length || lines[l].isEmpty() || lines[l].isBlank()) continue;
                            indent = 0;
                            while (lines[l].charAt(indent) == ' ') {
                                ++indent;
                            }
                            token = "";
                            i = indent;
                            while (lines[l].charAt(i) != ':') {
                                token = (String)token + lines[l].charAt(i);
                                ++i;
                            }
                            switch (token = ((String)token).trim()) {
                                case "type": {
                                    value = lines[l].substring(i + 1).trim();
                                    ar.setRenderParameter((String)token, (String)value);
                                    System.out.println(" dataservice param  = " + (String)token + " value = " + (String)value);
                                    break;
                                }
                                case "html": {
                                    value = lines[l].substring(i + 1);
                                    while (!lines[l].trim().endsWith("\"")) {
                                        value = (String)value + lines[++l] + "\n";
                                    }
                                    ar.setRenderParameter((String)token, ((String)value).trim().substring(1, ((String)value).length() - 3));
                                    System.out.println(" renderservice param  = " + (String)token + " value = " + (String)value);
                                    break;
                                }
                                default: {
                                    System.err.println("Invalid paramerter " + (String)token + " for renderservice");
                                }
                            }
                        } while (l < lines.length && !lines[l].isEmpty() && !lines[l].isBlank());
                    }
                }
            }
            ++l;
        }
    }
}

