/*
 * Decompiled with CFR 0.152.
 */
package org.bluesky.blueprint.data.mongo;

import com.mongodb.MongoClient;
import com.mongodb.client.MongoDatabase;
import org.bluesky.blueprint.data.DataContainer;
import org.bluesky.blueprint.data.mongo.DataMongoCreateService;
import org.bluesky.blueprint.data.mongo.DataMongoDeleteService;
import org.bluesky.blueprint.data.mongo.DataMongoFetchManyService;
import org.bluesky.blueprint.data.mongo.DataMongoFetchService;
import org.bluesky.blueprint.data.mongo.DataMongoUpdateService;

public class DataContainerMongo
extends DataContainer {
    private MongoClient mongoClient;
    private MongoDatabase database;

    public DataContainerMongo(int a_numOfOperators, String a_databasename) {
        super(a_numOfOperators);
        this.setup(a_databasename);
    }

    public DataContainerMongo(String a_domain, int a_numOfOperators, String a_databasename) {
        super(a_domain, a_numOfOperators);
        this.setup(a_databasename);
    }

    private void setup(String a_databasename) {
        this.mongoClient = new MongoClient();
        this.database = this.mongoClient.getDatabase(a_databasename);
        logger.log("Connected to mongodb " + a_databasename);
        this.addService(new DataMongoCreateService(this));
        this.addService(new DataMongoFetchService(this));
        this.addService(new DataMongoUpdateService(this));
        this.addService(new DataMongoDeleteService(this));
        this.addService(new DataMongoFetchManyService(this));
    }

    public MongoDatabase getDatabase() {
        return this.database;
    }
}

