/*
 * Decompiled with CFR 0.152.
 */
package org.bluesky.blueprint.data.mongo;

import com.google.gson.Gson;
import com.mongodb.client.MongoCollection;
import java.util.ArrayList;
import org.bluesky.blueprint.base.BluePrintException;
import org.bluesky.blueprint.base.Container;
import org.bluesky.blueprint.base.OPTYPE;
import org.bluesky.blueprint.base.Request;
import org.bluesky.blueprint.base.Service;
import org.bluesky.blueprint.data.DataContext;
import org.bluesky.blueprint.data.DataObject;
import org.bluesky.blueprint.data.DataRequest;
import org.bluesky.blueprint.data.mongo.DataContainerMongo;
import org.bson.Document;

public class DataMongoFetchManyService
extends Service {
    private Gson gson = new Gson();

    public DataMongoFetchManyService(Container a_owner) {
        super("FetchMany", a_owner);
    }

    @Override
    public void doWork(Request a_request) throws Exception {
        DataRequest dr = (DataRequest)a_request;
        DataContainerMongo dcm = (DataContainerMongo)this.owner;
        DataContext dc = (DataContext)a_request.getContext(OPTYPE.DATA);
        ArrayList<DataObject> dobjs = new ArrayList<DataObject>();
        String classname = dr.getClassObj().getClass().getSimpleName();
        try {
            MongoCollection<Document> col = dcm.getDatabase().getCollection(classname);
            for (Document doc : col.find()) {
                DataObject dobj = (DataObject)dr.getClassObj().getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
                dobj = (DataObject)this.gson.fromJson(doc.toJson(), dobj.getClass());
                dobjs.add(dobj);
            }
            dc.objectLists.put(classname, dobjs);
            Container.getLogger().debug("Fetched " + dobjs.size() + " Objects of type " + classname + " from Mongo Collection of same name");
        }
        catch (Exception e) {
            throw new BluePrintException(this, "Failed to Fetch Data Objects of type " + classname + "from Mongo Collection of same name Object does not exist");
        }
    }
}

