/*
 * Decompiled with CFR 0.152.
 */
package org.bluesky.blueprint.data.mongo;

import com.google.gson.Gson;
import com.mongodb.client.model.Filters;
import org.bluesky.blueprint.base.BluePrintException;
import org.bluesky.blueprint.base.Container;
import org.bluesky.blueprint.base.OPTYPE;
import org.bluesky.blueprint.base.Request;
import org.bluesky.blueprint.base.Service;
import org.bluesky.blueprint.data.DataContext;
import org.bluesky.blueprint.data.DataObject;
import org.bluesky.blueprint.data.DataRequest;
import org.bluesky.blueprint.data.mongo.DataContainerMongo;
import org.bson.Document;
import org.bson.conversions.Bson;

public class DataMongoFetchService
extends Service {
    private Gson gson = new Gson();

    public DataMongoFetchService(Container a_owner) {
        super("FetchObject", a_owner);
    }

    @Override
    public void doWork(Request a_request) throws Exception {
        Document doc;
        DataRequest dr = (DataRequest)a_request;
        DataContainerMongo dcm = (DataContainerMongo)this.owner;
        DataContext dc = (DataContext)a_request.getContext(OPTYPE.DATA);
        DataObject dobj = dc.objects.get(dr.getPbid());
        if (dobj != null && dobj.getDomain().equals(dcm.getDomain())) {
            Bson filter = Filters.eq("BPID", dobj.getBPID());
            doc = (Document)dcm.getDatabase().getCollection(dobj.getClass().getSimpleName()).find(filter).first();
            if (doc == null) {
                throw new BluePrintException(this, "Failed to Fetch Data Object of type " + dobj.getClass().getSimpleName() + " with ID " + dobj.getBPID() + "from Mongo Collection of same name Object does not exist");
            }
        } else {
            throw new BluePrintException(this, "No object or object not of domain " + this.owner.getDomain());
        }
        dobj = (DataObject)this.gson.fromJson(doc.toJson(), dobj.getClass());
        dc.objects.replace(dobj.getBPID(), dobj);
        Container.getLogger().debug("Data Object of type " + dobj.getClass().getSimpleName() + " with ID " + dobj.getBPID() + " fetched from Mongo Collection of same name");
    }
}

