/*
 * Decompiled with CFR 0.152.
 */
package org.bluesky.blueprint.data.mongo;

import com.google.gson.Gson;
import com.mongodb.client.model.Filters;
import org.bluesky.blueprint.base.BluePrintException;
import org.bluesky.blueprint.base.Container;
import org.bluesky.blueprint.base.OPTYPE;
import org.bluesky.blueprint.base.Request;
import org.bluesky.blueprint.base.Service;
import org.bluesky.blueprint.data.DataContext;
import org.bluesky.blueprint.data.DataObject;
import org.bluesky.blueprint.data.DataRequest;
import org.bluesky.blueprint.data.mongo.DataContainerMongo;
import org.bson.Document;
import org.bson.conversions.Bson;

public class DataMongoUpdateService
extends Service {
    private Gson gson = new Gson();

    public DataMongoUpdateService(Container a_owner) {
        super("UpdateObject", a_owner);
    }

    @Override
    public void doWork(Request a_request) throws Exception {
        Document doc;
        Bson filter;
        DataRequest dr = (DataRequest)a_request;
        DataContainerMongo dcm = (DataContainerMongo)this.owner;
        DataContext dc = (DataContext)a_request.getContext(OPTYPE.DATA);
        DataObject dobj = dc.objects.get(dr.getPbid());
        if (dobj != null && dobj.getDomain().equals(dcm.getDomain())) {
            filter = Filters.eq("BPID", dobj.getBPID());
            doc = (Document)dcm.getDatabase().getCollection(dobj.getClass().getSimpleName()).find(filter).first();
            if (doc == null) {
                throw new BluePrintException(this, "Failed to update Data Object of type " + dobj.getClass().getSimpleName() + " with ID " + dobj.getBPID() + "into Mongo Collection of same name as ID already exists in the collection");
            }
        } else {
            throw new BluePrintException(this, "No object or object not of domain " + this.owner.getDomain());
        }
        String json = this.gson.toJson(dobj);
        doc = Document.parse(json);
        dcm.getDatabase().getCollection(dobj.getClass().getSimpleName()).replaceOne(filter, doc);
        Container.getLogger().debug("Data Object of type " + dobj.getClass().getSimpleName() + " with ID " + dobj.getBPID() + " updated in Mongo Collection of same name");
    }
}

