/*
 * Decompiled with CFR 0.152.
 */
package org.bluesky.blueprint.file;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import org.bluesky.blueprint.base.BluePrintException;
import org.bluesky.blueprint.base.Container;
import org.bluesky.blueprint.base.OPTYPE;
import org.bluesky.blueprint.base.Request;
import org.bluesky.blueprint.base.Service;
import org.bluesky.blueprint.file.FileContainer;
import org.bluesky.blueprint.file.FileContext;
import org.bluesky.blueprint.file.FileRequest;

public class FileReadTextFileService
extends Service {
    public FileReadTextFileService(Container a_owner) {
        super("ReadTextFile", a_owner);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void doWork(Request _request) throws Exception {
        FileContext fc = (FileContext)_request.getContext(OPTYPE.FILE);
        FileRequest fr = (FileRequest)_request;
        String path = ((FileContainer)this.owner).getFileLocPath(fr.getLocation());
        if (path == null) throw new BluePrintException(this, "No Path mapping for location " + fr.getLocation());
        File f = new File(path + "/" + fr.getFilename());
        if (!f.isFile() || !f.canRead()) throw new BluePrintException(this, "File " + fr.getLocation() + "/" + fr.getFilename() + " at phyiscal path " + path + " does not exists or cannot be read");
        try {
            BufferedInputStream br = new BufferedInputStream(new FileInputStream(f));
            String contents = new String(br.readAllBytes());
            br.close();
            fc.addFile(fr.getLocation(), fr.getFilename(), contents);
            Container.getLogger().debug("Read " + contents.length() + " bytes from file " + fr.getLocation() + "/" + fr.getFilename() + " from path " + path);
            return;
        }
        catch (Exception e) {
            Container.getLogger().error("Error reading file " + fr.getLocation() + "/" + fr.getFilename() + " from path " + path + " with error " + e.getMessage());
            throw new BluePrintException(this, "Error reading file " + fr.getLocation() + "/" + fr.getFilename() + " from path " + path + " with error " + e.getMessage());
        }
    }
}

