/*
 * Decompiled with CFR 0.152.
 */
package org.bluesky.blueprint.job;

import java.util.Date;
import java.util.UUID;
import org.bluesky.blueprint.base.Container;
import org.bluesky.blueprint.job.JobSpec;
import org.bluesky.blueprint.job.JobStatus;

public abstract class Job
implements Runnable {
    protected String BPID = UUID.randomUUID().toString();
    protected String domain = "default";
    protected JobSpec spec;
    protected JobStatus status;
    protected Container container;

    public Job(String a_domain, JobSpec a_spec) {
        this.domain = a_domain;
        this.spec = a_spec;
        this.status = new JobStatus();
    }

    public Job(JobSpec a_spec) {
        this.spec = a_spec;
        this.status = new JobStatus();
    }

    public abstract boolean doWork();

    @Override
    public void run() {
        this.status.currentState = JobStatus.State.RUN;
        this.status.message = "";
        this.status.pct = 0.0;
        this.status.name = this.spec.getDisplayName();
        Container.getLogger().log("Job Execution " + this.spec.getDisplayName() + "[ID:" + this.BPID + "] Started");
        try {
            if (this.doWork()) {
                this.status.lastState = JobStatus.State.COMPLETE;
                this.status.pct = 100.0;
                this.status.lastRun = new Date();
                ++this.status.runCount;
                Container.getLogger().log("Job Execution " + this.spec.getDisplayName() + "[ID:" + this.BPID + "] Completed without error");
            } else {
                this.status.lastState = JobStatus.State.ERROR;
                this.status.pct = 100.0;
                this.status.lastError = new Date();
                ++this.status.errotCount;
                Container.getLogger().error("Job " + this.spec.getDisplayName() + "[ID:" + this.BPID + "] failed with last message" + this.status.message);
            }
        }
        catch (Exception e) {
            this.status.lastState = JobStatus.State.ERROR;
            this.status.pct = 100.0;
            this.status.lastError = new Date();
            ++this.status.errotCount;
            this.status.message = "Job Execution Failed with error " + e.getMessage();
            Container.getLogger().error("Job " + this.spec.getDisplayName() + "[ID:" + this.BPID + "] failed with error " + e.getMessage());
        }
        this.status.currentState = this.spec.getType() == JobSpec.Type.SINGLE ? JobStatus.State.DONE : JobStatus.State.WAIT;
    }

    public String getBPID() {
        return this.BPID;
    }

    public String getDomain() {
        return this.domain;
    }

    public JobStatus getStaus() {
        return this.status;
    }

    public JobSpec getSpec() {
        return this.spec;
    }

    public Container getContainer() {
        return this.container;
    }

    public void setContainer(Container container) {
        this.container = container;
    }
}

