/*
 * Decompiled with CFR 0.152.
 */
package org.bluesky.blueprint.job;

import java.util.HashMap;
import org.bluesky.blueprint.base.Request;
import org.bluesky.blueprint.base.Service;
import org.bluesky.blueprint.job.Job;
import org.bluesky.blueprint.job.JobContext;
import org.bluesky.blueprint.job.JobRequest;

public class JobClient {
    private Service service;

    public JobClient(Service a_service) {
        this.service = a_service;
    }

    public void startJob(Job job, JobContext jc) throws Exception {
        if (jc == null) {
            jc = new JobContext();
            jc.jobs.put(job.BPID, job);
        }
        JobRequest jr = new JobRequest("StartJob", this.service);
        jr.setPbid(job.BPID);
        jr.addContext(jc);
        this.service.request(jr);
        this.service.response(jr.getID());
        if (jr.getStatus() == Request.Status.FAULT) {
            throw jr.getFaultException();
        }
    }

    public void stopJob(Job job, JobContext jc) throws Exception {
        if (jc == null) {
            jc = new JobContext();
            jc.jobs.put(job.BPID, job);
        }
        JobRequest jr = new JobRequest("StopJob", this.service);
        jr.setPbid(job.BPID);
        jr.addContext(jc);
        this.service.request(jr);
        this.service.response(jr.getID());
        if (jr.getStatus() == Request.Status.FAULT) {
            throw jr.getFaultException();
        }
    }

    public HashMap<String, Job> getAllJobsStatus() throws Exception {
        JobContext jc = new JobContext();
        JobRequest jr = new JobRequest("GetJobStatus", this.service);
        jr.addContext(jc);
        this.service.request(jr);
        this.service.response(jr.getID());
        if (jr.getStatus() == Request.Status.FAULT) {
            throw jr.getFaultException();
        }
        return jc.jobs;
    }
}

