/*
 * Decompiled with CFR 0.152.
 */
package org.bluesky.blueprint.job;

import java.util.HashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.bluesky.blueprint.base.Container;
import org.bluesky.blueprint.base.OPTYPE;
import org.bluesky.blueprint.base.Service;
import org.bluesky.blueprint.job.GetJobStatusService;
import org.bluesky.blueprint.job.Job;
import org.bluesky.blueprint.job.JobBackgroundService;
import org.bluesky.blueprint.job.StartJobService;
import org.bluesky.blueprint.job.StopJobService;

public class JobContainer
extends Container {
    private ScheduledExecutorService executorService;
    private Service backGroundService;
    private HashMap<String, Job> activeJobs = new HashMap();

    public JobContainer(int numOfOperators, int jobPoolSize) {
        super(OPTYPE.JOB, numOfOperators);
        this.executorService = new ScheduledThreadPoolExecutor(jobPoolSize);
        this.backGroundService = new JobBackgroundService(this);
        this.addService(new StartJobService(this));
        this.addService(new StopJobService(this));
        this.addService(new GetJobStatusService(this));
        this.addService(this.backGroundService);
    }

    public JobContainer(String domain, int numOfOperators, int jobPoolSize) {
        super(OPTYPE.JOB, domain, numOfOperators);
        this.executorService = new ScheduledThreadPoolExecutor(jobPoolSize);
        this.backGroundService = new JobBackgroundService(this);
        this.addService(new StartJobService(this));
        this.addService(new StopJobService(this));
        this.addService(new GetJobStatusService(this));
        this.addService(this.backGroundService);
    }

    public HashMap<String, Job> getActiveJobs() {
        return this.activeJobs;
    }

    public ScheduledExecutorService getExecutorService() {
        return this.executorService;
    }

    public Service getBackgroundService() {
        return this.backGroundService;
    }
}

