/*
 * Decompiled with CFR 0.152.
 */
package org.bluesky.blueprint.job;

import java.util.Date;
import java.util.Properties;
import java.util.concurrent.TimeUnit;

public class JobSpec {
    private Type type;
    private String displayName;
    private Date from;
    private long interval;
    private TimeUnit intervalUnits;
    private Properties parameters = new Properties();

    public JobSpec(String a_name, Date a_from, Properties a_params) {
        this.type = Type.SINGLE;
        this.displayName = a_name;
        this.from = a_from;
        this.parameters = a_params;
        this.interval = 0L;
        this.intervalUnits = TimeUnit.MILLISECONDS;
    }

    public JobSpec(Type type, String displayName, Date from, int interval, TimeUnit intervalUnits, Properties parameters) {
        this.type = type;
        this.displayName = displayName;
        this.from = from;
        this.interval = interval;
        this.intervalUnits = intervalUnits;
        this.parameters = parameters;
    }

    public Type getType() {
        return this.type;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Date getFrom() {
        return this.from;
    }

    public long getInterval() {
        return this.interval;
    }

    public TimeUnit getIntervalUnits() {
        return this.intervalUnits;
    }

    public Properties getParameters() {
        return this.parameters;
    }

    public static enum Type {
        SINGLE,
        RATE,
        DELAY;

    }
}

