/*
 * Decompiled with CFR 0.152.
 */
package org.bluesky.blueprint.job;

import java.util.concurrent.TimeUnit;
import org.bluesky.blueprint.base.BluePrintException;
import org.bluesky.blueprint.base.Container;
import org.bluesky.blueprint.base.OPTYPE;
import org.bluesky.blueprint.base.Request;
import org.bluesky.blueprint.base.Service;
import org.bluesky.blueprint.job.Job;
import org.bluesky.blueprint.job.JobContainer;
import org.bluesky.blueprint.job.JobContext;
import org.bluesky.blueprint.job.JobRequest;
import org.bluesky.blueprint.job.JobSpec;

public class StartJobService
extends Service {
    public StartJobService(Container a_ownwer) {
        super("StartJob", a_ownwer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void doWork(Request _request) throws Exception {
        JobContext jc = (JobContext)_request.getContext(OPTYPE.JOB);
        JobRequest jr = (JobRequest)_request;
        JobContainer jctr = (JobContainer)this.owner;
        if (jc == null) throw new BluePrintException(this, "No Job Context found in request");
        Job job = jc.jobs.get(jr.getPbid());
        if (job == null) throw new BluePrintException(this, "No Job in Context for id " + jr.getPbid());
        job.setContainer(jctr);
        long delay = job.spec.getFrom().getTime() - System.currentTimeMillis();
        TimeUnit timems = TimeUnit.MILLISECONDS;
        long interval = timems.convert(job.spec.getInterval(), job.spec.getIntervalUnits());
        if (delay < 0L) {
            delay = 1L;
        }
        if (job.spec.getType() == JobSpec.Type.SINGLE) {
            job.status.scheduledFuture = jctr.getExecutorService().schedule(job, 1L, TimeUnit.SECONDS);
            jctr.getActiveJobs().put(job.BPID, job);
            return;
        } else if (job.spec.getType() == JobSpec.Type.DELAY) {
            job.status.scheduledFuture = jctr.getExecutorService().scheduleWithFixedDelay(job, delay, interval, timems);
            jctr.getActiveJobs().put(job.BPID, job);
            return;
        } else {
            if (job.spec.getType() != JobSpec.Type.RATE) return;
            job.status.scheduledFuture = jctr.getExecutorService().scheduleAtFixedRate(job, delay, interval, timems);
            jctr.getActiveJobs().put(job.BPID, job);
        }
    }
}

