/*
 * Decompiled with CFR 0.152.
 */
package org.bluesky.blueprint.logger;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import org.bluesky.blueprint.base.BluePrintException;
import org.bluesky.blueprint.base.Logger;

public class SimplePrintLogger
extends Logger {
    private HashMap<String, String> tags;

    public SimplePrintLogger(Properties props) throws BluePrintException {
        super(props);
        String defString = props.getProperty("logger.print.tags", "ALL");
        defString = defString.replace("ALL", "INFO,DEBUG,ERROR");
        this.tags = new HashMap();
        for (String tag : defString.split(",")) {
            this.tags.put(tag, tag);
        }
    }

    @Override
    public void log(String message) {
        System.out.println("[" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()) + "][INFO] " + message);
        if (this.next != null) {
            this.next.log(message);
        }
    }

    @Override
    public void debug(String message) {
        System.out.println("[" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()) + "][DEBUG] " + message);
        if (this.next != null) {
            this.next.debug(message);
        }
    }

    @Override
    public void error(String message) {
        System.err.println("[" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()) + "][ERROR] " + message);
        if (this.next != null) {
            this.next.error(message);
        }
    }

    @Override
    public void logWithTag(String tag, String message) {
        System.out.println("[" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()) + "][" + tag + "] " + message);
        if (this.next != null) {
            this.next.logWithTag(tag, message);
        }
    }
}

