/*
 * Decompiled with CFR 0.152.
 */
package org.bluesky.blueprint.monitor;

import java.util.HashMap;
import org.bluesky.blueprint.base.Container;
import org.bluesky.blueprint.base.OPTYPE;
import org.bluesky.blueprint.base.Request;
import org.bluesky.blueprint.base.Service;
import org.bluesky.blueprint.file.FileClient;
import org.bluesky.blueprint.job.Job;
import org.bluesky.blueprint.job.JobClient;
import org.bluesky.blueprint.web.WebContext;

public class MonitorJobsService
extends Service {
    private String fileCache = null;
    private int respCode;
    private final String LOCATION = "BPpages";
    private final String FILENAME = "MonitorJobs.html";

    public MonitorJobsService(Container a_owner) {
        super("AppJobs", a_owner);
    }

    @Override
    public void doWork(Request a_request) throws Exception {
        WebContext c = (WebContext)a_request.getContext(OPTYPE.WEB);
        if (c != null) {
            String action;
            if (this.fileCache == null) {
                try {
                    this.fileCache = new FileClient(this).readTextFile("BPpages", "MonitorJobs.html", null);
                    this.respCode = 200;
                }
                catch (Exception e) {
                    this.fileCache = "<html><h1>404 - Page not found</h1></html>";
                    this.respCode = 404;
                }
            }
            if ((action = c.getParameters().get("action")) == null || action.equals("stop")) {
                // empty if block
            }
            JobClient jc = new JobClient(this);
            HashMap<String, Job> jobs = jc.getAllJobsStatus();
            Object listTxt = "";
            for (Job j : jobs.values()) {
                listTxt = (String)listTxt + "<tr><td>" + j.getStaus().name + "</td><td>" + String.valueOf((Object)j.getStaus().currentState) + "</td><td>" + String.valueOf((Object)j.getStaus().lastState) + "</td><td>" + j.getStaus().message + "</td><td>" + j.getStaus().pct + "</td><td>" + String.valueOf(j.getStaus().lastRun) + "</td><td>" + String.valueOf(j.getStaus().lastError) + "</td><td>" + String.valueOf(j.getStaus().nextRun) + "</td><td>" + j.getStaus().runCount + "</td><td>" + j.getStaus().errotCount + "</td><td><div class=\"btn-group-sm\"><a href=\"Stock?action=stop&id=" + j.getBPID() + "\" class=\"btn btn-info\" role=\"button\">Stop</a>\n</div></td></tr>\n";
            }
            String finalTxt = this.fileCache.replace("{list}", (CharSequence)listTxt);
            c.responseCode = this.respCode;
            c.response = finalTxt.getBytes();
        } else {
            Container.getLogger().error("Missing Context for PAGE webService " + this.subType);
        }
    }
}

