/*
 * Decompiled with CFR 0.152.
 */
package org.bluesky.blueprint.security;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bluesky.blueprint.base.BluePrintException;
import org.bluesky.blueprint.base.Container;
import org.bluesky.blueprint.base.OPTYPE;
import org.bluesky.blueprint.base.Service;

public class SecurityContainer
extends Container {
    private final String TokenKeyProp = "secrets.key";
    private final String Alg = "AES";
    private final int size = 256;

    public SecurityContainer(int _numOperators) {
        super(OPTYPE.SECURITY, _numOperators);
    }

    public SecurityContainer(String a_domain, int _numOperators) {
        super(OPTYPE.SECURITY, a_domain, _numOperators);
    }

    public String encrypt(String clearText, Service serice) throws BluePrintException {
        String ret = "";
        SecretKey secretKey = null;
        String bkey = "";
        if (Container.appProps.containsKey("secrets.key")) {
            bkey = Container.appProps.getProperty("secrets.key");
            byte[] key = Base64.getDecoder().decode(bkey);
            secretKey = new SecretKeySpec(key, "AES");
        } else {
            try {
                KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
                SecureRandom secureRandom = new SecureRandom();
                int keyBitSize = 256;
                keyGenerator.init(keyBitSize, secureRandom);
                secretKey = keyGenerator.generateKey();
                bkey = Base64.getEncoder().encodeToString(secretKey.getEncoded());
                appProps.setProperty("secrets.key", bkey);
                try {
                    SecurityContainer.saveProperties();
                }
                catch (Exception e) {
                    logger.error("Failed to update properties with Key " + e.getMessage());
                    throw new BluePrintException(serice, "Failed to update properties with Key " + e.getMessage());
                }
            }
            catch (NoSuchAlgorithmException e) {
                logger.error("Key Generation Failed " + e.getMessage());
                throw new BluePrintException(serice, "Encryption Generation " + e.getMessage());
            }
        }
        try {
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(1, secretKey);
            ret = Base64.getEncoder().encodeToString(cipher.doFinal(clearText.getBytes()));
        }
        catch (Exception e) {
            logger.error("Encryption Failed " + e.getMessage());
            throw new BluePrintException(serice, "Encryption Failed " + e.getMessage());
        }
        return ret;
    }

    public String decrypt(String encText, Service serice) throws BluePrintException {
        String ret = "";
        SecretKeySpec secretKey = null;
        String bkey = "";
        if (Container.appProps.containsKey("secrets.key")) {
            bkey = Container.appProps.getProperty("secrets.key");
            byte[] key = Base64.getDecoder().decode(bkey);
            secretKey = new SecretKeySpec(key, "AES");
            byte[] enc = Base64.getDecoder().decode(encText);
            try {
                Cipher cipher = Cipher.getInstance("AES");
                cipher.init(2, secretKey);
                ret = new String(cipher.doFinal(enc));
            }
            catch (Exception e) {
                logger.error("Decyption Failed" + e.getMessage());
                throw new BluePrintException(serice, "Decyption Failed" + e.getMessage());
            }
        } else {
            logger.error("No key in Properties file");
            throw new BluePrintException(serice, "No key in Properties file");
        }
        return ret;
    }
}

