/*
 * Decompiled with CFR 0.152.
 */
package org.bluesky.blueprint.security.authentication;

import java.util.Hashtable;
import java.util.Properties;
import javax.naming.AuthenticationException;
import javax.naming.AuthenticationNotSupportedException;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import org.bluesky.blueprint.security.SecurityContainer;
import org.bluesky.blueprint.security.authentication.GetLdapGroupsService;
import org.bluesky.blueprint.security.authentication.GetLdapUserGroupsService;
import org.bluesky.blueprint.security.authentication.LdapAuthenticateService;

public class AuthLdapContainer
extends SecurityContainer {
    protected String ldapdomain;
    protected Hashtable<String, String> environment = new Hashtable();
    protected String url;

    public AuthLdapContainer(String ldapdomain, int a_numOfOperators) {
        super(a_numOfOperators);
        this.setup(ldapdomain);
    }

    public AuthLdapContainer(String ldapdomian, String a_domain, int a_numOperators, Properties appProps) {
        super(a_domain, a_numOperators);
        this.setup(this.ldapdomain);
    }

    private void setup(String ldapdomain) {
        this.ldapdomain = ldapdomain;
        this.addService(new GetLdapGroupsService(this));
        this.addService(new GetLdapUserGroupsService(this));
        this.addService(new LdapAuthenticateService(this));
        this.url = "ldap://" + appProps.getProperty("ldap." + this.ldapdomain + ".host") + ":" + appProps.getProperty("ldap." + this.ldapdomain + ".port");
        this.environment.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        this.environment.put("java.naming.provider.url", this.url);
        this.environment.put("java.naming.security.authentication", "simple");
        this.environment.put("java.naming.security.principal", appProps.getProperty("ldap." + this.ldapdomain + ".bindDN"));
        this.environment.put("java.naming.security.credentials", appProps.getProperty("ldap." + this.ldapdomain + ".password"));
        try {
            InitialDirContext context = new InitialDirContext(this.environment);
            logger.log("Connected to ldap domain" + this.ldapdomain + " with url " + this.url);
            context.close();
        }
        catch (AuthenticationNotSupportedException exception) {
            logger.error("Faild to connect to ldap domian " + this.ldapdomain + " The authentication is not supported by the server: " + exception.getMessage());
        }
        catch (AuthenticationException exception) {
            logger.error("Faild to connect to ldap domian " + this.ldapdomain + " Incorrect password or username: " + exception.getMessage());
        }
        catch (NamingException exception) {
            logger.error("Faild to connect to ldap domian " + this.ldapdomain + " Error when trying to create the context: " + exception.getMessage());
        }
    }
}

