/*
 * Decompiled with CFR 0.152.
 */
package org.bluesky.blueprint.security.authentication;

import java.util.ArrayList;
import javax.naming.AuthenticationException;
import javax.naming.AuthenticationNotSupportedException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.bluesky.blueprint.base.BluePrintException;
import org.bluesky.blueprint.base.Container;
import org.bluesky.blueprint.base.OPTYPE;
import org.bluesky.blueprint.base.Request;
import org.bluesky.blueprint.base.Service;
import org.bluesky.blueprint.security.authentication.AuthContext;
import org.bluesky.blueprint.security.authentication.AuthLdapContainer;

public class GetLdapGroupsService
extends Service {
    public GetLdapGroupsService(Container a_ownwer) {
        super("GetLdapGroups", a_ownwer);
    }

    @Override
    public void doWork(Request _request) throws Exception {
        AuthContext ac = (AuthContext)_request.getContext(OPTYPE.SECURITY);
        if (ac != null) {
            try {
                InitialDirContext adminContext = new InitialDirContext(((AuthLdapContainer)this.owner).environment);
                Container.getLogger().log("GetLdapGroups: Connected to ldap domain " + ac.domain);
                ac.groups = new ArrayList();
                String filter = (String)Container.getAppProperties().get("ldap." + ac.domain + ".groupsquery");
                String[] attrIDs = new String[]{"cn"};
                SearchControls searchControls = new SearchControls();
                searchControls.setReturningAttributes(attrIDs);
                searchControls.setSearchScope(2);
                NamingEnumeration<SearchResult> searchResults = adminContext.search((String)Container.getAppProperties().get("ldap." + ac.domain + ".baseDN"), filter, searchControls);
                while (searchResults.hasMore()) {
                    SearchResult result = searchResults.next();
                    Attributes attrs = result.getAttributes();
                    String grp = attrs.get("cn").toString().replace("cn:", "").trim();
                    ac.groups.add(grp);
                    Container.getLogger().debug("GetLdapGroups: Found group = " + grp);
                }
                adminContext.close();
            }
            catch (AuthenticationNotSupportedException exception) {
                throw new BluePrintException(this, "Faild to search to ldap domian " + ac.domain + " The authentication is not supported by the server: " + exception.getMessage());
            }
            catch (AuthenticationException exception) {
                throw new BluePrintException(this, "Faild to search to ldap domian " + ac.domain + " Incorrect password or username: " + exception.getMessage());
            }
            catch (NamingException exception) {
                throw new BluePrintException(this, "Faild to search to ldap domain " + ac.domain + " Error when trying to create the context: " + exception.getMessage());
            }
        } else {
            throw new BluePrintException(this, "No Securiy Context found in request");
        }
    }
}

