/*
 * Decompiled with CFR 0.152.
 */
package org.bluesky.blueprint.security.authentication;

import java.sql.Timestamp;
import java.time.Instant;
import java.util.Hashtable;
import javax.naming.AuthenticationException;
import javax.naming.AuthenticationNotSupportedException;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import org.bluesky.blueprint.base.BluePrintException;
import org.bluesky.blueprint.base.Container;
import org.bluesky.blueprint.base.OPTYPE;
import org.bluesky.blueprint.base.Request;
import org.bluesky.blueprint.base.Service;
import org.bluesky.blueprint.security.SecurityContainer;
import org.bluesky.blueprint.security.authentication.AuthContext;
import org.bluesky.blueprint.security.authentication.AuthLdapContainer;

public class LdapAuthenticateService
extends Service {
    public LdapAuthenticateService(Container a_ownwer) {
        super("LdapAuthenticate", a_ownwer);
    }

    @Override
    public void doWork(Request _request) throws Exception {
        AuthContext ac = (AuthContext)_request.getContext(OPTYPE.SECURITY);
        boolean doauth = false;
        String pw = "";
        if (ac != null) {
            Timestamp exp;
            Container.getLogger().log("User Authenticate: User " + ac.username + " in LDAP domain" + ((AuthLdapContainer)this.owner).ldapdomain);
            if (ac.token != null) {
                int delpos;
                String ctoken = ((SecurityContainer)this.owner).decrypt(ac.token, this);
                exp = Timestamp.valueOf(ctoken.substring(0, (delpos = ctoken.indexOf("--")) - 1));
                if (exp.before(Timestamp.from(Instant.now()))) {
                    pw = ctoken.substring(delpos + 1);
                    doauth = true;
                } else {
                    Container.getLogger().log("User Re-Authenticated");
                }
            } else {
                doauth = true;
                pw = ac.password;
            }
            if (doauth) {
                String userdn = Container.getAppProperties().getProperty("ldap." + ((AuthLdapContainer)this.owner).ldapdomain + ".autheticatequery");
                userdn = userdn.replace("{USERNAME}", ac.username);
                Hashtable<String, String> env = new Hashtable<String, String>();
                env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
                env.put("java.naming.provider.url", ((AuthLdapContainer)this.owner).url);
                env.put("java.naming.security.authentication", "simple");
                env.put("java.naming.security.principal", userdn);
                env.put("java.naming.security.credentials", pw);
                try {
                    InitialDirContext context = new InitialDirContext(env);
                    Container.getLogger().log("User " + ac.username + " authenticated in domain " + ((AuthLdapContainer)this.owner).ldapdomain);
                    context.close();
                    exp = new Timestamp(Timestamp.from(Instant.now()).getTime() + Long.parseLong(Container.getAppProperties().getProperty("secrets.tokentimesec", "0")));
                    ac.password = null;
                    ac.token = ((SecurityContainer)this.owner).encrypt(exp.toString() + "--" + pw, this);
                    Container.getLogger().log("User Authenticated");
                }
                catch (AuthenticationNotSupportedException exception) {
                    Container.getLogger().error("Failed to connect to ldap domian " + ((AuthLdapContainer)this.owner).ldapdomain + " The authentication is not supported by the server: " + exception.getMessage());
                    throw new BluePrintException(this, "Failed to Authenticate user. Ldap Error " + ac.username);
                }
                catch (AuthenticationException exception) {
                    Container.getLogger().error("Failed to connect to ldap domian " + ((AuthLdapContainer)this.owner).ldapdomain + " Incorrect password or username: " + exception.getMessage());
                    throw new BluePrintException(this, "Failed to Authenticate user. Invalid Username or Password " + ac.username);
                }
                catch (NamingException exception) {
                    Container.getLogger().error("Failed to connect to ldap domian " + ((AuthLdapContainer)this.owner).ldapdomain + " Error when trying to create the context: " + exception.getMessage());
                    throw new BluePrintException(this, "Failed to Authenticate user. Ldap Error " + ac.username);
                }
            }
        } else {
            throw new BluePrintException(this, "No Securiy Context found in request");
        }
    }
}

