/*
 * Decompiled with CFR 0.152.
 */
package org.bluesky.blueprint.web;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.HttpCookie;
import java.util.UUID;
import org.bluesky.blueprint.base.Container;
import org.bluesky.blueprint.base.OPTYPE;
import org.bluesky.blueprint.base.Request;
import org.bluesky.blueprint.base.Service;
import org.bluesky.blueprint.web.Session;
import org.bluesky.blueprint.web.WebContext;

public class WebContainer
extends Container
implements HttpHandler {
    private Service resourceManager;
    public Service apiManager;
    public Service pageManager;
    private String authWeb = "";
    private String authAPI = "";
    private String passcodeService = "";
    protected HttpServer server;

    public WebContainer(int a_numOperators, HttpServer a_server) {
        super(OPTYPE.WEB, a_numOperators);
        this.server = a_server;
        this.loadService();
    }

    public WebContainer(String a_domian, int a_numOperators, HttpServer a_server) {
        super(OPTYPE.WEB, a_domian, a_numOperators);
        this.server = a_server;
        this.loadService();
    }

    private void loadService() {
        Constructor<?> constructor;
        Class<?> c;
        String pagesclass = Container.appProps.getProperty(this.domain + ".web.pageservice", "org.bluesky.blueprint.web.WebPageMainService");
        String resourceclass = Container.appProps.getProperty(this.domain + ".web.resouceservice", "org.bluesky.blueprint.web.WebResourceMainService");
        String apiclass = Container.appProps.getProperty(this.domain + ".web.apiservice", "org.bluesky.blueprint.web.WebAPIMainService");
        try {
            c = Class.forName(pagesclass);
            constructor = c.getConstructor(Container.class);
            this.pageManager = (Service)constructor.newInstance(this);
            this.addService(this.pageManager);
            logger.log("Page Manager service of class " + pagesclass + " added to WebContainer");
        }
        catch (Exception e) {
            logger.error("Failed to instantiate service of class " + pagesclass + " as Page Manager. Exception: " + e.getMessage());
        }
        try {
            c = Class.forName(resourceclass);
            constructor = c.getConstructor(Container.class);
            this.resourceManager = (Service)constructor.newInstance(this);
            this.addService(this.resourceManager);
            logger.log("Resource Manager service of class " + resourceclass + " added to WebContainer");
        }
        catch (Exception e) {
            logger.error("Failed to instantiate service of class " + resourceclass + " as Resource Manager. Exception: " + e.getMessage());
        }
        try {
            c = Class.forName(apiclass);
            constructor = c.getConstructor(Container.class);
            this.apiManager = (Service)constructor.newInstance(this);
            this.addService(this.apiManager);
            logger.log("API Manager service of class " + apiclass + " added to WebContainer");
        }
        catch (Exception e) {
            logger.error("Failed to instantiate service of class " + apiclass + " as API Manager. Exception: " + e.getMessage());
        }
        this.authAPI = Container.getAppProperties().getProperty("auth.api." + this.domain);
        this.authWeb = Container.getAppProperties().getProperty("auth.web." + this.domain);
        this.passcodeService = Container.getAppProperties().getProperty("auth.passcode.service", "");
        if (this.passcodeService != "" && this.authWeb.equals("passcode")) {
            try {
                c = Class.forName(this.passcodeService);
                constructor = c.getConstructor(Container.class);
                Service auth = (Service)constructor.newInstance(this);
                this.passcodeService = auth.getSubType().replace("App", "");
                this.addService(auth);
                logger.log("Passcode auth page service of class " + this.passcodeService + " added to WebContainer");
            }
            catch (Exception e) {
                logger.error("Failed to instantiate service of class " + this.passcodeService + " as passcode auth service. Exception: " + e.getMessage());
            }
        }
        this.server.createContext("/" + this.domain, this);
    }

    @Override
    public void handle(HttpExchange a_exchange) throws IOException {
        WebContext c = new WebContext();
        c.exchange = a_exchange;
        String sid = c.exchange.getRequestHeaders().getFirst("Cookie");
        if (sid != null) {
            c.session = Session.getSession(UUID.fromString(sid.split("=")[1].replaceAll("\"", "")));
            if (c.session == null) {
                logger.error("Cannot Establish Web Session ID");
            }
        } else {
            c.session = new Session();
            HttpCookie cookie = new HttpCookie("sessionId", c.session.getID().toString());
            c.exchange.getResponseHeaders().add("Set-Cookie", cookie.toString());
        }
        c.response = null;
        c.responseCode = 0;
        Request req = null;
        boolean auth = false;
        System.out.println(c.getServiceString());
        if (c.getServiceString().startsWith("/resource")) {
            req = new Request(OPTYPE.WEB, this.domain, this.resourceManager.getSubType(), null);
        } else if (c.getServiceString().startsWith("/api")) {
            switch (this.authAPI) {
                case "none": {
                    auth = true;
                    break;
                }
                case "session": {
                    if (c.session != null && c.session.getAuthentication() != null && c.session.getAuthentication().isAuthenticated()) {
                        auth = true;
                    } else {
                        c.responseCode = 401;
                        c.responseMime = "application/json";
                        c.response = "{ \"error\" : \"Unauthorized\" }".getBytes();
                    }
                    logger.log(" Failed to authorise API call " + c.getServiceString());
                    break;
                }
                default: {
                    c.responseCode = 401;
                    c.responseMime = "application/json";
                    c.response = "{ \"error\" : \"Authorization Not configured\" }".getBytes();
                    logger.error("Authication for web API not configured");
                }
            }
            if (auth) {
                req = new Request(OPTYPE.WEB, this.domain, this.apiManager.getSubType(), null);
            }
        } else {
            switch (this.authWeb) {
                case "passcode": {
                    if (c.session.getAuthentication() == null) {
                        c.source = c.getServiceString();
                        c.setRedirect(this.passcodeService);
                        break;
                    }
                    c.setRedirect(null);
                    break;
                }
                case "none": {
                    break;
                }
                default: {
                    c.responseCode = 401;
                    c.responseMime = "application/json";
                    c.response = "{ \"error\" : \"Authorization Not configured\" }".getBytes();
                    logger.error("Authication for web page not configured");
                }
            }
            req = new Request(OPTYPE.WEB, this.domain, this.pageManager.getSubType(), null);
        }
        req.addContext(c);
        logger.debug("WebService request for " + c.getContextString() + c.getServiceString());
        this.request(req);
    }

    public Service getResourceManager() {
        return this.resourceManager;
    }
}

