/*
 * Decompiled with CFR 0.152.
 */
package org.bluesky.blueprint.web;

import com.sun.net.httpserver.Headers;
import java.io.IOException;
import org.bluesky.blueprint.base.Container;
import org.bluesky.blueprint.base.OPTYPE;
import org.bluesky.blueprint.base.Request;
import org.bluesky.blueprint.base.Service;
import org.bluesky.blueprint.web.WebContext;

public class WebPageMainService
extends Service {
    public WebPageMainService(Container a_owner) {
        super("MainPage", a_owner);
    }

    @Override
    public void doWork(Request a_request) throws Exception {
        WebContext c = (WebContext)a_request.getContext(OPTYPE.WEB);
        c.responseMime = "text/html";
        Request request = new Request(OPTYPE.WEB, this.owner.getDomain(), "App" + c.getServiceString().replace("/", ""), this);
        if (this.owner.getService(request.getService()) != null) {
            request.addContext(c);
            try {
                long rid = this.request(request);
                this.response(rid);
                if (request.getStatus() == Request.Status.RESPONSE) {
                    if (c.responseCode == 0) {
                        c.responseCode = 200;
                    }
                } else {
                    throw request.getFaultException();
                }
                Container.getLogger().debug("Successful execution of service " + c.getContextString() + "/" + c.getServiceString() + " with return code " + c.responseCode);
            }
            catch (Exception e) {
                c.responseCode = 500;
                c.response = ("<html><h1>500 - Server Error </h1><br><h2> Message = " + e.getMessage() + "</html>").getBytes();
                Container.getLogger().error("Unsuccessful execution of service " + c.getContextString() + c.getServiceString() + " with return code " + c.responseCode);
            }
        } else {
            c.responseCode = 404;
            c.response = "<html><h1>404 - Page not found</h1></html>".getBytes();
            Container.getLogger().error("Page not found for " + request.getService());
        }
        Headers responseHeaders = c.exchange.getResponseHeaders();
        responseHeaders.set("Content-Type", c.responseMime);
        try {
            c.exchange.sendResponseHeaders(c.responseCode, 0L);
            c.exchange.getResponseBody().write(c.response);
            c.exchange.getResponseBody().flush();
            c.exchange.getResponseBody().close();
        }
        catch (IOException e) {
            Container.getLogger().error("Error sending Page response " + e.getLocalizedMessage());
            throw e;
        }
    }
}

