/*
 * Decompiled with CFR 0.152.
 */
package org.bluesky.blueprint.web;

import com.sun.net.httpserver.Headers;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import org.bluesky.blueprint.base.BluePrintException;
import org.bluesky.blueprint.base.Container;
import org.bluesky.blueprint.base.OPTYPE;
import org.bluesky.blueprint.base.Request;
import org.bluesky.blueprint.base.Service;
import org.bluesky.blueprint.data.yaml.DataYamlDocument;
import org.bluesky.blueprint.data.yaml.DocumentDataObject;
import org.bluesky.blueprint.web.WebContext;
import org.bluesky.blueprint.web.WebPageCache;
import org.bluesky.blueprint.web.component.WebComponentContainer;
import org.bluesky.blueprint.web.component.WebComponentContext;

public class WebPlanMainService
extends Service {
    private String pageroot;
    private String comproot;
    private WebPageCache pageCache = new WebPageCache();
    private static DataYamlDocument pageDefs = null;
    private static DataYamlDocument compDefs = null;

    public WebPlanMainService(Container a_owner) {
        super("PlanMain", a_owner);
        this.pageroot = (String)Container.getAppProperties().get(this.owner.getDomain() + ".web.planpagehome");
        this.comproot = (String)Container.getAppProperties().get(this.owner.getDomain() + ".web.plancomponentshome");
    }

    private void loadDefs() throws BluePrintException {
        String line;
        BufferedReader reader;
        ArrayList<String> doc = new ArrayList<String>();
        if (pageDefs == null) {
            try {
                reader = new BufferedReader(new FileReader(this.pageroot + "/page_defs.yaml"));
                line = reader.readLine();
                while (line != null) {
                    doc.add(line);
                    line = reader.readLine();
                }
                reader.close();
                pageDefs = new DataYamlDocument(Container.getLogger());
                pageDefs.parseDoc(doc);
                Container.getLogger().log("page_defs.yaml from " + this.pageroot);
            }
            catch (IOException e) {
                throw new BluePrintException("Error reading page_defs.yaml from " + this.pageroot + " " + e.getMessage());
            }
        }
        if (compDefs == null) {
            doc = new ArrayList();
            try {
                reader = new BufferedReader(new FileReader(this.comproot + "/component_defs.yaml"));
                line = reader.readLine();
                while (line != null) {
                    doc.add(line);
                    line = reader.readLine();
                }
                reader.close();
                compDefs = new DataYamlDocument(Container.getLogger());
                compDefs.parseDoc(doc);
                Container.getLogger().log("component_defs.yaml from " + this.comproot);
            }
            catch (IOException e) {
                throw new BluePrintException("Error reading component_defs.yaml from " + this.comproot + " " + e.getMessage());
            }
        }
    }

    private String loadPage(String a_pageName) throws BluePrintException {
        Object page = "";
        try {
            BufferedReader reader = new BufferedReader(new FileReader(this.pageroot + "/" + a_pageName));
            String line = reader.readLine();
            while (line != null) {
                page = (String)page + line;
                line = reader.readLine();
            }
            reader.close();
        }
        catch (IOException e) {
            throw new BluePrintException("Error reading page_defs.yaml from " + this.pageroot + " " + e.getMessage());
        }
        return page;
    }

    @Override
    public void doWork(Request a_request) throws Exception {
        long rid;
        this.loadDefs();
        WebContext c = (WebContext)a_request.getContext(OPTYPE.WEB);
        c.responseMime = "text/html";
        c.responseCode = 200;
        Object path = c.getServiceString();
        if (((String)path).isEmpty()) {
            path = (String)path + "index";
        }
        String pageType = "";
        String pageParam = "";
        String page = "";
        try {
            pageType = (String)((DocumentDataObject)((ArrayList)pageDefs.getDocument().getAttribute((String)path)).get(0)).getAttribute("type");
            pageParam = (String)((DocumentDataObject)((ArrayList)pageDefs.getDocument().getAttribute((String)path)).get(0)).getAttribute("param");
        }
        catch (Exception e) {
            c.responseCode = 500;
            c.response = "<html><h1>500 - Server Error </h1><br><h2> Failed to get page Definition</html>".getBytes();
            Container.getLogger().error("Failed to get Page Definition for " + c.getContextString() + c.getServiceString() + " due to " + e.getMessage());
        }
        if (c.responseCode == 200) {
            if (pageType.equals("file")) {
                page = this.pageCache.getCachedPage((String)path);
                if (page == null) {
                    page = this.loadPage(pageParam);
                    this.pageCache.cachePage((String)path, page);
                    Container.getLogger().debug("Page loaded for " + (String)path + " from " + this.pageroot + "/" + pageParam);
                }
            } else if (pageType.equals("service")) {
                Request request = new Request(OPTYPE.WEB, this.owner.getDomain(), pageParam, this);
                if (this.owner.getService(request.getService()) != null) {
                    request.addContext(c);
                    try {
                        rid = this.request(request);
                        this.response(rid);
                        if (request.getStatus() == Request.Status.RESPONSE) {
                            if (c.responseCode == 0) {
                                c.responseCode = 200;
                                page = new String(c.response);
                            }
                        } else {
                            throw request.getFaultException();
                        }
                        Container.getLogger().debug("Successful execution of service " + c.getContextString() + "/" + c.getServiceString() + " with return code " + c.responseCode);
                    }
                    catch (Exception e) {
                        c.responseCode = 500;
                        c.response = ("<html><h1>500 - Server Error </h1><br><h2> Message = " + e.getMessage() + "</html>").getBytes();
                        Container.getLogger().error("Unsuccessful execution of service " + c.getContextString() + c.getServiceString() + " with return code " + c.responseCode);
                    }
                } else {
                    c.responseCode = 404;
                    c.response = "<html><h1>404 - Page not found</h1></html>".getBytes();
                    Container.getLogger().error("Page not found for " + request.getService());
                }
            } else {
                c.responseCode = 500;
                c.response = ("<html><h1>500 - Server Error </h1><br><h2>Unknown Page Type definition " + pageType + "</h2></html>").getBytes();
                Container.getLogger().error("Unknown Page Type Definition " + pageType);
            }
        }
        ArrayList<String> divs = WebComponentContainer.getComponentDiv(page);
        page = WebComponentContainer.addHeader(page, "\t\t<meta charset=\"utf-8\">\n\t\t<meta name=\"viewport\" content=\"width=device-width, initial-scale=1\">\t\t<link href=\"https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css\" rel=\"stylesheet\" integrity=\"sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC\" crossorigin=\"anonymous\">");
        for (String div : divs) {
            String compName = "";
            int start = div.indexOf("class=\"bpp_") + 11;
            int end = div.indexOf("\"", start);
            compName = div.substring(start, end);
            String compType = (String)((DocumentDataObject)((ArrayList)compDefs.getDocument().getAttribute(compName)).get(0)).getAttribute("type");
            String compParam = (String)((DocumentDataObject)((ArrayList)compDefs.getDocument().getAttribute(compName)).get(0)).getAttribute("param");
            if (compType != null && compParam != null) {
                if (compType.equals("file")) continue;
                if (compType.equals("service")) {
                    WebComponentContext wcc = new WebComponentContext();
                    wcc.configDiv = div;
                    Request request = new Request(OPTYPE.WEBCOMP, this.owner.getDomain(), compParam, this);
                    request.addContext(c);
                    request.addContext(wcc);
                    try {
                        rid = this.request(request);
                        this.response(rid);
                        if (request.getStatus() == Request.Status.RESPONSE) {
                            page = page.replace(div, wcc.divReplace);
                            Container.getLogger().debug("Successful execution of service " + c.getContextString() + "/" + c.getServiceString() + " with return code " + c.responseCode);
                            continue;
                        }
                        throw request.getFaultException();
                    }
                    catch (Exception e) {
                        c.responseCode = 500;
                        c.response = ("<html><h1>500 - Server Error </h1><br><h2> Message = " + e.getMessage() + "</html>").getBytes();
                        Container.getLogger().error("Unsuccessful execution of service " + c.getContextString() + c.getServiceString() + " with return code " + c.responseCode);
                        continue;
                    }
                }
                Container.getLogger().error("Now compoent type " + compType + " for component " + compName);
                continue;
            }
            Container.getLogger().error("Now compoent definition for " + compName);
        }
        c.response = page.getBytes();
        Headers responseHeaders = c.exchange.getResponseHeaders();
        responseHeaders.set("Content-Type", c.responseMime);
        try {
            c.exchange.sendResponseHeaders(c.responseCode, 0L);
            c.exchange.getResponseBody().write(c.response);
            c.exchange.getResponseBody().flush();
            c.exchange.getResponseBody().close();
        }
        catch (IOException e) {
            Container.getLogger().error("Error sending Page response " + e.getLocalizedMessage());
            throw e;
        }
    }
}

