/*
 * Decompiled with CFR 0.152.
 */
package org.bluesky.blueprint.web.component;

import java.util.ArrayList;
import org.bluesky.blueprint.base.Container;
import org.bluesky.blueprint.base.OPTYPE;
import org.bluesky.blueprint.web.component.WebCompAutoForm;
import org.bluesky.blueprint.web.component.WebCompAutoTable;
import org.bluesky.blueprint.web.component.WebCompSinpleSummary;

public class WebComponentContainer
extends Container {
    public static final String BSHEADER = "\t\t<meta charset=\"utf-8\">\n\t\t<meta name=\"viewport\" content=\"width=device-width, initial-scale=1\">\t\t<link href=\"https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css\" rel=\"stylesheet\" integrity=\"sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC\" crossorigin=\"anonymous\">";

    public WebComponentContainer(int _numOperators) {
        super(OPTYPE.WEBCOMP, _numOperators);
        this.setup();
    }

    public WebComponentContainer(String a_domain, int _numOperators) {
        super(OPTYPE.WEBCOMP, a_domain, _numOperators);
        this.setup();
    }

    private void setup() {
        this.addService(new WebCompAutoForm(this));
        this.addService(new WebCompAutoTable(this));
        this.addService(new WebCompSinpleSummary(this));
    }

    public static String addHeader(String a_page, String a_item) {
        Object ret = a_page;
        String lpage = a_page.toLowerCase();
        int start = lpage.toLowerCase().indexOf("<head>");
        if (start >= 0) {
            start += 6;
            if (lpage.indexOf(a_item) == -1) {
                ret = a_page.substring(0, start) + "\n" + a_item + "\n" + a_page.substring(start);
            }
        } else {
            start = lpage.indexOf("<body>");
            if (start > -1) {
                ret = a_page.substring(0, start) + "<head>\n" + a_item + "</head>\n" + a_page.substring(start);
            }
        }
        return ret;
    }

    public static ArrayList<String> getComponentDiv(String a_page) {
        String sub = "";
        String lpage = a_page.toLowerCase();
        int start = 0;
        int end = 0;
        ArrayList<String> ret = new ArrayList<String>();
        while (start > -1) {
            start = lpage.indexOf("<div ", end);
            if (start <= -1 || !(sub = lpage.substring(start, (end = lpage.indexOf("</div>", start)) + 6)).contains("class=\"bpp_")) continue;
            ret.add(sub);
        }
        return ret;
    }

    public static String replaceDiv(String a_page, String a_compName, String a_content) {
        String ret = a_page;
        String sub = "";
        String lpage = a_page.toLowerCase();
        int start = 0;
        while (sub.isEmpty() && start > -1) {
            int end;
            start = lpage.indexOf("<div ");
            if (start <= -1 || !(sub = lpage.substring(start, (end = lpage.indexOf("</div>", start)) + 6)).contains("class=\"bpp_" + a_compName)) continue;
            ret = ret.replace(sub, a_content);
        }
        return ret;
    }
}

