/*
 * Decompiled with CFR 0.152.
 */
package com.bluesky.clearsky.data;

import java.sql.Date;
import java.sql.Time;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Locale;
import org.bluesky.blueprint.base.BluePrintException;
import org.bluesky.blueprint.data.DataObject;
import org.bluesky.blueprint.data.DataObjectAttribute;

public class ObservatorySQMReadingDataObject
extends DataObject {
    private DateTimeFormatter fdate = DateTimeFormatter.ofPattern("yyyy/MM/dd", Locale.ENGLISH);
    private DateTimeFormatter ftime = DateTimeFormatter.ofPattern("HH:mm:ss", Locale.ENGLISH);
    private static ArrayList<DataObjectAttribute> metadata = new ArrayList();

    static {
        metadata.add(new DataObjectAttribute("mdate", DataObjectAttribute.DataType.DATE, 100));
        metadata.add(new DataObjectAttribute("mtime", DataObjectAttribute.DataType.TIME, 100));
        metadata.add(new DataObjectAttribute("MPSAS", DataObjectAttribute.DataType.FLOAT, 0));
        metadata.add(new DataObjectAttribute("NELM", DataObjectAttribute.DataType.FLOAT, 0));
        metadata.add(new DataObjectAttribute("temp_c", DataObjectAttribute.DataType.FLOAT, 0));
        metadata.add(new DataObjectAttribute("enc_offset", DataObjectAttribute.DataType.FLOAT, 0));
        metadata.add(new DataObjectAttribute("solar_alt_deg", DataObjectAttribute.DataType.FLOAT, 0));
        metadata.add(new DataObjectAttribute("lunar_alt_deg", DataObjectAttribute.DataType.FLOAT, 0));
        metadata.add(new DataObjectAttribute("lunar_phase", DataObjectAttribute.DataType.FLOAT, 0));
    }

    public ObservatorySQMReadingDataObject() {
    }

    public ObservatorySQMReadingDataObject(String a_BPID) {
        super(a_BPID);
    }

    public void populateFromString(String data) throws BluePrintException {
        String[] parts = data.split(",");
        if (parts.length == 13) {
            try {
                this.setAttribute("mdate", Date.valueOf(LocalDate.parse(parts[0], this.fdate)));
            }
            catch (Exception e) {
                throw new BluePrintException("Invalid value for mdate " + parts[0]);
            }
            try {
                this.setAttribute("mtime", Time.valueOf(LocalTime.parse(parts[1], this.ftime)));
            }
            catch (Exception e) {
                throw new BluePrintException("Invalid value for mtime " + parts[1]);
            }
            try {
                this.setAttribute("MPSAS", Double.parseDouble(parts[2]));
            }
            catch (Exception e) {
                throw new BluePrintException("Invalid value for MPSAS" + parts[2]);
            }
            try {
                this.setAttribute("NELM", Double.parseDouble(parts[3]));
            }
            catch (Exception e) {
                throw new BluePrintException("Invalid value for NELM" + parts[3]);
            }
            try {
                this.setAttribute("temp_c", Double.parseDouble(parts[8]));
            }
            catch (Exception e) {
                throw new BluePrintException("Invalid value for temp_c" + parts[8]);
            }
            try {
                this.setAttribute("enc_offset", Double.parseDouble(parts[9]));
            }
            catch (Exception e) {
                throw new BluePrintException("Invalid value for enc_offset" + parts[9]);
            }
            try {
                this.setAttribute("solar_alt_deg", Double.parseDouble(parts[10]));
            }
            catch (Exception e) {
                throw new BluePrintException("Invalid value for solar_alt_deg" + parts[10]);
            }
            try {
                this.setAttribute("lunar_alt_deg", Double.parseDouble(parts[11]));
            }
            catch (Exception e) {
                throw new BluePrintException("Invalid value for lunar_alt_deg" + parts[11]);
            }
            try {
                this.setAttribute("lunar_phase", Double.parseDouble(parts[12]));
            }
            catch (Exception e) {
                throw new BluePrintException("Invalid value for lunar_phase" + parts[12]);
            }
        }
        throw new BluePrintException("Wrong number of fields in data string Expecting 13 got " + parts.length);
    }

    public ArrayList<DataObjectAttribute> getAttributeMetaData() {
        return metadata;
    }

    public String getDomain() {
        return "clearsky";
    }

    public String getName() {
        return "ObservatorySQMReading";
    }

    public DataObject CreateDataObject(String a_PBID) {
        return new ObservatorySQMReadingDataObject(a_PBID);
    }
}

