/*
 * Decompiled with CFR 0.152.
 */
package com.bluesky.clearsky.web;

import com.bluesky.clearsky.data.LocationDataObject;
import com.bluesky.clearsky.data.MobileSQMDataObject;
import com.bluesky.clearsky.data.MobileSQMReadingDataObject;
import java.sql.Date;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.bluesky.blueprint.base.Container;
import org.bluesky.blueprint.base.OPTYPE;
import org.bluesky.blueprint.base.Request;
import org.bluesky.blueprint.base.Service;
import org.bluesky.blueprint.data.DataClient;
import org.bluesky.blueprint.data.DataObject;
import org.bluesky.blueprint.data.DataObjectAttribute;
import org.bluesky.blueprint.file.FileClient;
import org.bluesky.blueprint.web.WebContext;

public class DataEntryService
extends Service {
    private String floc = "pages";
    private String page;
    private String dataentry;
    private ArrayList<DataObject> locations;
    private ArrayList<DataObject> devices;
    private String slocations = "<option></option>";
    private String sdevices = "<option></option>";
    private HashMap<String, String> valids;
    private HashMap<String, String> values;
    private String locDetails = "";
    private String readingsMesg = "";
    private String qualityMesg = "";
    private String TZ = "";
    private String notes = "";
    private String[] wqualiity = new String[]{"Perfectly Clear", "Light Haze", "Horizon Haze", "Partly Cloudy"};
    private String swquality = "<option></option>";
    private String buttons;
    DataClient dc = null;
    MobileSQMReadingDataObject loc = null;

    public DataEntryService(Container a_owner) {
        super("AppDataEntry", a_owner);
    }

    public void doWork(Request a_request) throws Exception {
        WebContext c = (WebContext)a_request.getContext(OPTYPE.WEB);
        String resp = "";
        c.responseCode = 200;
        if (this.page == null) {
            try {
                this.page = new FileClient((Service)this).readTextFile(this.floc, "pagewithhome.html", null);
                this.dataentry = new FileClient((Service)this).readTextFile(this.floc, "dataentry.html", null);
                this.page = this.page.replace("{pagename}", "SQM Data Entry Page");
                this.valids = new HashMap();
                this.values = new HashMap();
            }
            catch (Exception e) {
                resp = "<html><h1>Internal error page files not loaded</h1></html>";
                Container.getLogger().error("Data Entry page could not load page files with exception: " + e.getMessage());
                c.responseCode = 500;
            }
        }
        if (c.responseCode == 200) {
            try {
                String action = (String)c.getRequestParameters().get("action");
                if (action == null || action.equals("repeat")) {
                    if (this.dc == null) {
                        this.dc = new DataClient((Service)this);
                        this.locations = this.dc.FetchManyDataObjects((DataObject)new LocationDataObject(), null);
                        this.devices = this.dc.FetchManyDataObjects((DataObject)new MobileSQMDataObject(), null);
                    }
                    this.sdevices = "<option></option>";
                    for (DataObject dobj : this.devices) {
                        this.sdevices = String.valueOf(this.sdevices) + "<option>" + String.valueOf(dobj.getAttribute("Serial_no")) + "</option>";
                    }
                    this.slocations = "<option></option>";
                    for (DataObject dobj : this.locations) {
                        this.slocations = String.valueOf(this.slocations) + "<option>" + String.valueOf(dobj.getAttribute("Name")) + "</option>";
                    }
                    this.swquality = "<option></option>";
                    String[] stringArray = this.wqualiity;
                    int n = this.wqualiity.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s2 = stringArray[n2];
                        this.swquality = String.valueOf(this.swquality) + "<option>" + s2 + "</option>";
                        ++n2;
                    }
                    this.buttons = "<input type=\"submit\" class=\"btn btn-primary\" value=\"validate\" name=\"action\">";
                    this.qualityMesg = "";
                    this.readingsMesg = "";
                    this.TZ = "<option>GMT / UTC</option><option>BST</option>";
                    this.notes = "";
                    for (DataObjectAttribute attr : new MobileSQMReadingDataObject().getAttributeMetaData()) {
                        this.valids.put(attr.name, "");
                        this.values.put(attr.name, "");
                    }
                    resp = this.page.replace("{pagebody}", this.dataentry);
                    resp = resp.replace("{locs}", this.slocations);
                    resp = resp.replace("{devs}", this.sdevices);
                    resp = resp.replace("{weather}", this.swquality);
                    resp = resp.replace("{buttons}", this.buttons);
                    resp = this.applyValids(resp);
                    resp = this.applyValues(resp);
                    resp = resp.replace("{error_msg}", this.readingsMesg);
                    resp = resp.replace("{quality_msg}", this.qualityMesg);
                    resp = resp.replace("{TZ}", this.TZ);
                    resp = resp.replace("{notes}", this.notes);
                } else if (action.equals("validate") || action.equals("re-validate")) {
                    if (this.loc == null) {
                        this.loc = new MobileSQMReadingDataObject();
                    }
                    resp = this.page.replace("{pagebody}", this.dataentry);
                    this.validate(this.loc, c);
                    resp = resp.replace("{locs}", this.slocations);
                    resp = resp.replace("{devs}", this.sdevices);
                    resp = resp.replace("{locDetails}", this.locDetails);
                    resp = resp.replace("{weather}", this.swquality);
                    resp = resp.replace("{buttons}", this.buttons);
                    resp = this.applyValids(resp);
                    resp = this.applyValues(resp);
                    resp = resp.replace("{error_msg}", this.readingsMesg);
                    resp = resp.replace("{quality_msg}", this.qualityMesg);
                    resp = resp.replace("{TZ}", this.TZ);
                    resp = resp.replace("{notes}", this.notes);
                } else if (action.equals("submit")) {
                    String msg = "<form action=\"darksky/DataEntry\" method=\"post\">  <h2>{msg}</h2>  <h3>Please select Repeat to enter another set of readings or Finish to exit</h3>  <input type=\"submit\" class=\"btn btn-primary\" value=\"repeat\" name=\"action\">  <input type=\"submit\" class=\"btn btn-primary\" value=\"finish\" name=\"action\"></form>";
                    Object logstring = "";
                    for (DataObjectAttribute attr : this.loc.getAttributeMetaData()) {
                        logstring = (String)logstring + attr.name + "=" + String.valueOf(this.loc.getAttribute(attr.name)) + ",";
                    }
                    try {
                        this.dc.CreateODatabject((DataObject)this.loc, null);
                        Container.getLogger().logWithTag("READINGS", "SQM data inserted with parameters " + (String)logstring);
                        msg = msg.replace("{msg}", "Your readings have been sucessfully recorded to the database");
                    }
                    catch (Exception e) {
                        Container.getLogger().error("SQM insert failed with parameters " + (String)logstring);
                        Container.getLogger().error("SQM insert failed with message " + e.getMessage());
                        msg = msg.replace("{msg}", "There was a problem recoding your readings to the database.However, all details have been logged and will be looked at by our team. There is no need to re-enter results currently, but please keep a physical copy of the readings");
                    }
                    resp = this.page;
                    resp = resp.replace("{pagebody}", msg);
                    this.loc = null;
                } else if (action.equals("finish")) {
                    resp = this.page.replace("{pagebody}", "<h2>Thank you for supporting the Marlborough dark skies project!");
                }
                c.responseCode = 200;
            }
            catch (Exception e) {
                resp = "<html><h1>Internal Error - Processing page</h1></html>";
                c.responseCode = 500;
                Container.getLogger().error("Data Entry page failure with exception: " + e.getMessage());
            }
        }
        c.response = resp.getBytes();
    }

    private String applyValids(String a_doc) {
        String ret = a_doc;
        for (DataObjectAttribute a : new MobileSQMReadingDataObject().getAttributeMetaData()) {
            ret = ret.replace("{" + a.name + "-valid}", this.valids.get(a.name));
        }
        return ret;
    }

    private String applyValues(String a_doc) {
        String ret = a_doc;
        for (DataObjectAttribute a : new MobileSQMReadingDataObject().getAttributeMetaData()) {
            ret = ret.replace("{" + a.name + "-value}", this.values.get(a.name));
        }
        return ret;
    }

    private boolean validate(MobileSQMReadingDataObject a_reading, WebContext a_context) {
        boolean ret = true;
        int qualitynum = 10;
        double[] readings = new double[5];
        double[] mreadings = new double[5];
        boolean valid = true;
        this.readingsMesg = "";
        this.qualityMesg = "";
        block48: for (DataObjectAttribute attr : a_reading.getAttributeMetaData()) {
            String val = (String)a_context.getRequestParameters().get(attr.name);
            if (val != null) {
                this.values.put(attr.name, val);
            }
            block25 : switch (attr.name) {
                case "location": {
                    if (val == null) {
                        this.slocations = "<option></option>";
                        this.valids.put(attr.name, "is-invalid");
                        valid = false;
                        for (DataObject loc : this.locations) {
                            this.slocations = String.valueOf(this.slocations) + "<option>" + String.valueOf(loc.getAttribute("Name"));
                        }
                        continue block48;
                    }
                    this.slocations = "<option></option>";
                    for (DataObject loc : this.locations) {
                        if (val.equals(loc.getAttribute("Name"))) {
                            a_reading.setAttribute("location", loc.getAttribute("LID"));
                            this.locDetails = String.valueOf(loc.getAttribute("Details")) + "<br>What3words: " + String.valueOf(loc.getAttribute("What3Words")) + " Long: " + String.valueOf(loc.getAttribute("Longitude")) + " Lat: " + String.valueOf(loc.getAttribute("Latitude"));
                            this.slocations = String.valueOf(this.slocations) + "<option selected=\"selected\">" + String.valueOf(loc.getAttribute("Name"));
                            continue;
                        }
                        this.slocations = String.valueOf(this.slocations) + "<option>" + String.valueOf(loc.getAttribute("Name"));
                    }
                    this.valids.put(attr.name, "is-valid");
                    break;
                }
                case "device": {
                    if (val == null) {
                        this.valids.put(attr.name, "is-invalid");
                        valid = false;
                        this.sdevices = "<option></option>";
                        for (DataObject dev : this.devices) {
                            this.sdevices = String.valueOf(this.sdevices) + "<option>" + String.valueOf(dev.getAttribute("Serial_no"));
                        }
                        continue block48;
                    }
                    this.sdevices = "<option></option>";
                    for (DataObject dev : this.devices) {
                        if (val.equals(dev.getAttribute("Serial_no"))) {
                            a_reading.setAttribute("device", dev.getAttribute("LID"));
                            this.sdevices = String.valueOf(this.sdevices) + "<option selected=\"selected\">" + String.valueOf(dev.getAttribute("Serial_no"));
                            continue;
                        }
                        this.sdevices = String.valueOf(this.sdevices) + "<option>" + String.valueOf(dev.getAttribute("Serial_no"));
                    }
                    this.valids.put(attr.name, "is-valid");
                    break;
                }
                case "TZ": {
                    if (val.equals("BST")) {
                        this.TZ = "<option>GMT / UTC</option><option selected=\"selected\">BST</option>";
                        a_reading.setAttribute(attr.name, "1");
                        break;
                    }
                    this.TZ = "<option selected=\"selected\">GMT / UTC</option><option >BST</option>";
                    a_reading.setAttribute(attr.name, "0");
                    break;
                }
                case "mdate": {
                    if (val == null) {
                        this.valids.put(attr.name, "is-invalid");
                        valid = false;
                        break;
                    }
                    this.valids.put(attr.name, "is-valid");
                    a_reading.setAttribute("mdate", Date.valueOf(val));
                    break;
                }
                case "mtime_1": 
                case "mtime_2": 
                case "mtime_3": 
                case "mtime_4": 
                case "mtime_5": {
                    if (val == null) {
                        this.valids.put(attr.name, "is-invalid");
                        this.readingsMesg = String.valueOf(this.readingsMesg) + "<p>No time for " + attr.name.replace("mtime_", "") + "</p>";
                        valid = false;
                        break;
                    }
                    this.valids.put(attr.name, "is-valid");
                    a_reading.setAttribute(attr.name, Time.valueOf(val + ":00"));
                    break;
                }
                case "temp_c_1": 
                case "temp_c_2": 
                case "temp_c_3": 
                case "temp_c_4": 
                case "temp_c_5": {
                    if (val == null) {
                        this.valids.put(attr.name, "is-invalid");
                        this.readingsMesg = String.valueOf(this.readingsMesg) + "<p>No temperature for " + attr.name.replace("temp_c_", "") + "</p>";
                        valid = false;
                        break;
                    }
                    int temp = 0;
                    try {
                        temp = Integer.parseInt(val);
                        if (temp < -20 || temp > 30) {
                            --qualitynum;
                            this.qualityMesg = String.valueOf(this.qualityMesg) + "<p>Temp for reading " + attr.name.replace("temp_c_", "") + " appears to be out normal ranges (-20 to 30 deg C)<p>";
                        }
                        this.valids.put(attr.name, "is-valid");
                        a_reading.setAttribute(attr.name, temp);
                    }
                    catch (Exception e) {
                        this.readingsMesg = String.valueOf(this.readingsMesg) + "<p>Tempatture for reading " + attr.name.replace("temp_c_", "") + " is not a valid number</p>";
                    }
                    continue block48;
                }
                case "MPSAS_1": 
                case "MPSAS_2": 
                case "MPSAS_3": 
                case "MPSAS_4": 
                case "MPSAS_5": {
                    if (val == null) {
                        this.valids.put(attr.name, "is-invalid");
                        this.readingsMesg = String.valueOf(this.readingsMesg) + "<p>No value for reading " + attr.name.replace("MPSAS_", "") + "</p>";
                        valid = false;
                        break;
                    }
                    double mpsas = 0.0;
                    try {
                        mpsas = Double.parseDouble(val);
                        if (mpsas < 10.0 || mpsas > 22.0) {
                            this.readingsMesg = String.valueOf(this.readingsMesg) + "<p>MPSAS  reading " + attr.name.replace("MPSAS_", "") + " is not within normal bounds (10.0 to 22.0)</p>";
                            this.valids.put(attr.name, "is-invalid");
                            break;
                        }
                        this.valids.put(attr.name, "is-valid");
                        a_reading.setAttribute(attr.name, mpsas);
                        readings[Integer.parseInt((String)attr.name.replace((CharSequence)"MPSAS_", (CharSequence)"")) - 1] = mpsas;
                        mreadings[Integer.parseInt((String)attr.name.replace((CharSequence)"MPSAS_", (CharSequence)"")) - 1] = mpsas;
                        double nelm = 7.93 - 5.0 * Math.log10(Math.pow(10.0, 4.316 - mpsas / 5.0) + 1.0);
                        a_reading.setAttribute(attr.name.replace("MPSAS", "NELM"), nelm);
                    }
                    catch (Exception e) {
                        this.readingsMesg = String.valueOf(this.readingsMesg) + "<p>Value for reading " + attr.name.replace("MPSAS_", "") + " is not a valid number</p>";
                        valid = false;
                    }
                    continue block48;
                }
                case "weather_quality": {
                    if (val == null) {
                        this.valids.put(attr.name, "is-invalid");
                        valid = false;
                        break;
                    }
                    this.valids.put(attr.name, "is-valid");
                    a_reading.setAttribute(attr.name, val);
                    this.swquality = "<option></option>";
                    String[] stringArray = this.wqualiity;
                    int n = this.wqualiity.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s2 = stringArray[n2];
                        this.swquality = s2.equals(val) ? String.valueOf(this.swquality) + "<option selected=\"selected\">" + s2 + "</option>" : String.valueOf(this.swquality) + "<option>" + s2 + "</option>";
                        ++n2;
                    }
                    switch (val) {
                        case "Light Haze": {
                            qualitynum -= 2;
                            this.qualityMesg = String.valueOf(this.qualityMesg) + "<p>Weather quality is " + val + "</p>";
                            break block25;
                        }
                        case "Horizon Haze": {
                            --qualitynum;
                            this.qualityMesg = String.valueOf(this.qualityMesg) + "<p>Weather quality is " + val + "</p>";
                            break block25;
                        }
                        case "Partly Cloudy": {
                            qualitynum -= 3;
                            this.qualityMesg = String.valueOf(this.qualityMesg) + "<p>Weather quality is " + val + "</p>";
                            break block25;
                        }
                    }
                    break;
                }
                case "notes": {
                    if (val == null) break;
                    this.notes = val;
                    a_reading.setAttribute(attr.name, val);
                    break;
                }
            }
        }
        Arrays.sort(mreadings);
        double median = mreadings[2];
        int i = 1;
        double[] dArray = readings;
        int n = readings.length;
        int n3 = 0;
        while (n3 < n) {
            double r = dArray[n3];
            if (r > median * 1.1 || r < median * 0.9) {
                --qualitynum;
                this.qualityMesg = String.valueOf(this.qualityMesg) + "<p>Reading " + i + " is possible outlier check value is correct</p>";
            }
            ++i;
            ++n3;
        }
        if (valid) {
            this.buttons = "<input type=\"submit\" class=\"btn btn-primary\" value=\"re-validate\" name=\"action\">\n<input type=\"submit\" class=\"btn btn-primary\" value=\"submit\" name=\"action\">";
            a_reading.setAttribute("quaility_indicator", qualitynum);
            a_reading.setAttribute("quaility_msg", this.qualityMesg);
            this.qualityMesg = qualitynum == 10 ? "<p>Quality score is 10/10</p>" : "<p>Quality score is " + qualitynum + "/10 Due to:</p>" + this.qualityMesg;
        } else {
            this.qualityMesg = "";
        }
        return ret;
    }
}

