/*
 * Decompiled with CFR 0.152.
 */
package com.bluesky.clearsky.web;

import com.bluesky.clearsky.data.LocationDataObject;
import java.util.ArrayList;
import org.bluesky.blueprint.base.Container;
import org.bluesky.blueprint.base.OPTYPE;
import org.bluesky.blueprint.base.Request;
import org.bluesky.blueprint.base.Service;
import org.bluesky.blueprint.data.DataClient;
import org.bluesky.blueprint.data.DataObject;
import org.bluesky.blueprint.file.FileClient;
import org.bluesky.blueprint.web.WebContext;

public class LocationsService
extends Service {
    public LocationsService(Container a_owner) {
        super("AppLocations", a_owner);
    }

    public void doWork(Request a_request) throws Exception {
        WebContext c = (WebContext)a_request.getContext(OPTYPE.WEB);
        String page = "";
        c.responseCode = 200;
        try {
            page = new FileClient((Service)this).readTextFile("pages", "pagewithhome.html", null);
            page = page.replace("{pagename}", "Locations");
        }
        catch (Exception e) {
            c.response = "<html><h1>Internal error page could not be rendered</h1></html>".getBytes();
            Container.getLogger().error("Locations page could not load page files with exception: " + e.getMessage());
            c.responseCode = 500;
        }
        if (c.responseCode == 200) {
            try {
                DataClient dc = new DataClient((Service)this);
                ArrayList locs = dc.FetchManyDataObjects((DataObject)new LocationDataObject(), null);
                Object body = "<table class=\"table table-stripe\"><tr><th>Name</th><th>Details</th><th>What3Words</th><th>Longitude</th><th>Latitude</th></tr>";
                for (DataObject loc : locs) {
                    body = (String)body + "<tr><td>" + (String)loc.getAttribute("Name") + "</td>";
                    body = (String)body + "<td>" + (String)loc.getAttribute("Details") + "</td>";
                    body = (String)body + "<td>" + (String)loc.getAttribute("What3Words") + "</td>";
                    body = (String)body + "<td>" + (String)loc.getAttribute("Longitude") + "</td>";
                    body = (String)body + "<td>" + (String)loc.getAttribute("Latitude") + "</td>";
                }
                page = page.replace("{pagebody}", (String)body + "</tr></table>");
            }
            catch (Exception e) {
                c.response = "<html><h1>Internal error page could not be rendered</h1></html>".getBytes();
                Container.getLogger().error("Locations page could not fetch locaions: " + e.getMessage());
                c.responseCode = 500;
            }
        }
        if (c.responseCode == 200) {
            c.response = page.getBytes();
        }
    }
}

