/*
 * Decompiled with CFR 0.152.
 */
package com.bluesky.clearsky.web;

import org.bluesky.blueprint.base.Container;
import org.bluesky.blueprint.base.Context;
import org.bluesky.blueprint.base.OPTYPE;
import org.bluesky.blueprint.base.Request;
import org.bluesky.blueprint.base.Service;
import org.bluesky.blueprint.file.FileClient;
import org.bluesky.blueprint.security.authentication.AuthPasscodeClient;
import org.bluesky.blueprint.web.WebContext;

public class PasscodeLogin
extends Service {
    private String floc = "pages";
    private String page;

    public PasscodeLogin(Container a_owner) {
        super("AppPasscode", a_owner);
    }

    public void doWork(Request a_request) throws Exception {
        WebContext c = (WebContext)a_request.getContext(OPTYPE.WEB);
        String resp = "";
        c.responseCode = 200;
        if (this.page == null) {
            try {
                FileClient fc = new FileClient((Service)this);
                this.page = fc.readTextFile(this.floc, "page.html", null);
                this.page = this.page.replace("{pagename}", "Login");
                this.page = this.page.replace("{pagebody}", fc.readTextFile(this.floc, "login.html", null));
            }
            catch (Exception e) {
                resp = "<html><h1>Internal error page files not loaded</h1></html>";
                Container.getLogger().error("Data Entry page could not load page files with exception: " + e.getMessage());
                c.responseCode = 500;
            }
        }
        if (c.responseCode == 200) {
            try {
                if (c.getRequestParameters().containsKey("action")) {
                    String action = (String)c.getRequestParameters().get("action");
                    if (action.equals("login")) {
                        String passcode = (String)c.getRequestParameters().get("passcode");
                        if (passcode != null) {
                            AuthPasscodeClient apc = new AuthPasscodeClient((Service)this);
                            c.session.setAuthentication(apc.Authenticate(passcode));
                            if (!c.session.getAuthentication().isAuthenticated()) {
                                resp = this.page.replace("{errmsg}", "Invalid passcode please try again");
                            } else {
                                Request request = new Request(OPTYPE.WEB, this.owner.getDomain(), "App" + c.source.replace("/", ""), (Service)this);
                                request.addContext((Context)c);
                                c.setRedirect(null);
                                this.request(request);
                                this.response(request.getID());
                                resp = new String(c.response);
                            }
                        } else {
                            resp = this.page.replace("{errmsg}", "Please enter a Passcode");
                        }
                    }
                } else {
                    resp = this.page.replace("{errmsg}", "");
                }
            }
            catch (Exception e) {
                resp = "<html><h1>Internal Error - Processing page</h1></html>";
                c.responseCode = 500;
                Container.getLogger().error("Data Entry page failure with exception: " + e.getMessage());
            }
        }
        c.response = resp.getBytes();
    }
}

