/*
 * Decompiled with CFR 0.152.
 */
package com.bluesky.clearsky.web;

import com.bluesky.clearsky.AnalysisCommon;
import java.util.HashMap;
import org.bluesky.blueprint.analysis.AnalysisClient;
import org.bluesky.blueprint.analysis.AnalysisContext;
import org.bluesky.blueprint.analysis.AnalysisData;
import org.bluesky.blueprint.base.Container;
import org.bluesky.blueprint.base.OPTYPE;
import org.bluesky.blueprint.base.Request;
import org.bluesky.blueprint.base.Service;
import org.bluesky.blueprint.file.FileClient;
import org.bluesky.blueprint.web.WebContext;

public class SQMCLocationService
extends Service {
    private String page = null;
    private String content = "<table><tr><td>{map}</td><td>{key}</td></tr></table>";
    private String select;
    private int yearSelected = 2024;
    private int monthSelected = 1;
    private String valueSelected = "darkest";
    private AnalysisContext acd = null;

    public SQMCLocationService(Container a_owner) {
        super("AppSQMLocation", a_owner);
    }

    public void doWork(Request a_request) throws Exception {
        WebContext c = (WebContext)a_request.getContext(OPTYPE.WEB);
        c.responseCode = 200;
        try {
            if (c.getRequestParameters().containsKey("yearselect")) {
                this.yearSelected = Integer.parseInt((String)c.getRequestParameters().get("yearselect"));
            }
            if (c.getRequestParameters().containsKey("monthselect")) {
                this.monthSelected = Integer.parseInt((String)c.getRequestParameters().get("monthselect"));
            }
            if (c.getRequestParameters().containsKey("valueselect")) {
                this.valueSelected = (String)c.getRequestParameters().get("valueselect");
            }
            AnalysisClient acli = new AnalysisClient((Service)this);
            HashMap<String, Integer> ins = new HashMap<String, Integer>();
            if (this.page == null) {
                this.page = new FileClient((Service)this).readTextFile("pages", "pagewithhome.html", null);
                this.page = this.page.replace("{pagename}", "SQM Value by Location");
                this.acd = acli.RunAnalysis("sqmdatelist", ins, null);
            }
            ins.put("year", this.yearSelected);
            ins.put("month", this.monthSelected);
            AnalysisContext ac = acli.RunAnalysis("sqmlocation", ins, null);
            this.select = this.buildKey(this.acd);
            c.response = this.render(ac).getBytes();
        }
        catch (Exception e) {
            c.response = "<html><h1>Internal error page could not be rendered</h1></html>".getBytes();
            Container.getLogger().error("SQM Summary page could not load page files with exception: " + e.getMessage());
            c.responseCode = 500;
        }
    }

    private String buildData(AnalysisContext a_ac) {
        Object data = "";
        double latitude = 0.0;
        double longtitude = 0.0;
        double value = 0.0;
        int i = 0;
        while (i < ((AnalysisData)a_ac.analysisData.values().toArray()[0]).values.size()) {
            String loc = (String)((AnalysisData)a_ac.analysisData.get((Object)"location")).values.get(i);
            switch (this.valueSelected) {
                case "darkest": {
                    value = (Double)((AnalysisData)a_ac.analysisData.get((Object)"mmax")).values.get(i);
                    break;
                }
                case "average": {
                    value = (Double)((AnalysisData)a_ac.analysisData.get((Object)"mmean")).values.get(i);
                    break;
                }
                case "lightest": {
                    value = (Double)((AnalysisData)a_ac.analysisData.get((Object)"mmin")).values.get(i);
                }
            }
            latitude = Double.parseDouble((String)((AnalysisData)a_ac.analysisData.get((Object)"lat")).values.get(i));
            longtitude = Double.parseDouble((String)((AnalysisData)a_ac.analysisData.get((Object)"long")).values.get(i));
            data = (String)data + "\tvar p" + i + " = L.circle([" + latitude + ", " + longtitude + "], {\n\t\tcolor: " + AnalysisCommon.getBortalColor(value) + ",\n\t\tline: 1,\n\t\tfillColor: " + AnalysisCommon.getBortalColor(value) + ",\n\t\tfillOpacity: 0.5,\n\t\tradius: 600}).addTo(map);\n\tp" + i + ".bindPopup(\"" + loc + " mpsas= " + value + "\");\n";
            ++i;
        }
        return data;
    }

    private String buildKey(AnalysisContext a_ac) {
        Object ret = "<table><tr><th>Year</th></tr><tr><td><form action=\"#\" method=\"POST\">";
        ret = (String)ret + "<select name=\"yearselect\" id=\"yearselect\" onchange=\"this.form.submit()\"> ";
        Object years = "";
        Object months = "";
        int i = 0;
        while (i < ((AnalysisData)a_ac.analysisData.values().toArray()[0]).values.size()) {
            Integer year = (Integer)((AnalysisData)a_ac.analysisData.get((Object)"myear")).values.get(i);
            Integer month = (Integer)((AnalysisData)a_ac.analysisData.get((Object)"mmonth")).values.get(i);
            if (!((String)years).contains(year.toString())) {
                years = year == this.yearSelected ? (String)years + "<option value=\"" + String.valueOf(year) + "\" selected=true>" + String.valueOf(year) + "</option>" : (String)years + "<option value=\"" + String.valueOf(year) + "\" >" + String.valueOf(year) + "</option>";
            }
            if (year == this.yearSelected && !((String)months).contains(month.toString())) {
                months = month == this.monthSelected ? (String)months + "<option value=\"" + String.valueOf(month) + "\" selected=true>" + AnalysisCommon.months[month - 1] + "</option>" : (String)months + "<option value=\"" + String.valueOf(month) + "\" >" + AnalysisCommon.months[month - 1] + "</option>";
            }
            ++i;
        }
        ret = (String)ret + (String)years + "</select></form></td></tr>";
        ret = (String)ret + "<tr><th>Month</th></tr><tr><td><form action=\"#\" method=\"POST\">";
        ret = (String)ret + "<select name=\"monthselect\" id=\"monthselect\" onchange=\"this.form.submit()\"> " + (String)months + "</select></form></td></tr>";
        ret = (String)ret + "<tr><th>Value</th></tr><tr><td><form action=\"#\" method=\"POST\">";
        ret = (String)ret + "<select name=\"valueselect\" id=\"valueselect\" onchange=\"this.form.submit()\">";
        ret = this.valueSelected.equals("darkest") ? (String)ret + "<option value=\"darkest\" selected=true>Darkest</option>" : (String)ret + "<option value=\"darkest\" >Darkest</option>";
        ret = this.valueSelected.equals("average") ? (String)ret + "<option value=\"average\" selected=true>Average</option>" : (String)ret + "<option value=\"average\" >Average</option>";
        ret = this.valueSelected.equals("lightest") ? (String)ret + "<option value=\"lightest\" selected=true>Lightest</option>" : (String)ret + "<option value=\"lightest\" >Lightest</option>";
        ret = (String)ret + "</select>";
        ret = (String)ret + "</table>\n";
        ret = (String)ret + "<table><tr><th>Point Key = Bortle</th></tr>\n";
        i = 0;
        while (i < AnalysisCommon.bortleText.length) {
            ret = (String)ret + "\t<tr><td style=\"background-color: " + AnalysisCommon.bortleColours[i] + "; color: " + AnalysisCommon.bortleTextColour[i] + "\">" + AnalysisCommon.bortleText[i] + "</td></tr>\n";
            ++i;
        }
        ret = (String)ret + "</table></form></td></tr>\n";
        return ret;
    }

    private String render(AnalysisContext a_ac) {
        String ret = this.page.replace("{pagebody}", this.content);
        ret = ret.replace("{map}", a_ac.renderer);
        ret = ret.replace("{points}", this.buildData(a_ac));
        ret = ret.replace("{key}", this.select);
        return ret;
    }
}

