/*
 * Decompiled with CFR 0.152.
 */
package com.bluesky.clearsky.web;

import com.bluesky.clearsky.AnalysisCommon;
import java.util.ArrayList;
import java.util.HashMap;
import org.bluesky.blueprint.analysis.AnalysisClient;
import org.bluesky.blueprint.analysis.AnalysisContext;
import org.bluesky.blueprint.analysis.AnalysisData;
import org.bluesky.blueprint.base.Container;
import org.bluesky.blueprint.base.OPTYPE;
import org.bluesky.blueprint.base.Request;
import org.bluesky.blueprint.base.Service;
import org.bluesky.blueprint.file.FileClient;
import org.bluesky.blueprint.web.WebContext;

public class SQMChangeService
extends Service {
    private String page = null;
    private String content = "<table><tr><td>{Graph}</td><td>{key}</td></tr></table>";
    private String select;
    private String[] colours = new String[]{"#03045E", "#0077B6", "#00B4D8", "#90E0EF", "#CAF0F8"};
    private String[] textColour = new String[]{"white", "white", "black", "black", "black"};
    private String labels = "";
    private ArrayList<String> datasetName;
    private ArrayList<String> dataSetData;
    private ArrayList<String> datasetBortle;
    private int yearSelected = 2024;
    private String regionSelected = "Collingbourne Area";
    private String valueSelected = "darkest";
    private AnalysisContext acd = null;

    public SQMChangeService(Container a_owner) {
        super("AppSQMChange", a_owner);
    }

    public void doWork(Request a_request) throws Exception {
        WebContext c = (WebContext)a_request.getContext(OPTYPE.WEB);
        c.responseCode = 200;
        try {
            if (c.getRequestParameters().containsKey("yearselect")) {
                this.yearSelected = Integer.parseInt((String)c.getRequestParameters().get("yearselect"));
            }
            if (c.getRequestParameters().containsKey("regionselect")) {
                this.regionSelected = (String)c.getRequestParameters().get("regionselect");
            }
            if (c.getRequestParameters().containsKey("valueselect")) {
                this.valueSelected = (String)c.getRequestParameters().get("valueselect");
            }
            AnalysisClient acli = new AnalysisClient((Service)this);
            HashMap<String, Object> ins = new HashMap<String, Object>();
            if (this.page == null) {
                this.page = new FileClient((Service)this).readTextFile("pages", "pagewithhome.html", null);
                this.page = this.page.replace("{pagename}", "SQM Monthly Change");
                this.acd = acli.RunAnalysis("sqmchangeselect", ins, null);
            }
            ins.put("year", this.yearSelected);
            ins.put("region", this.regionSelected + "%");
            AnalysisContext ac = acli.RunAnalysis("sqmchange", ins, null);
            this.buildData(ac);
            this.select = this.buildKey(this.acd);
            c.response = this.render(ac).getBytes();
        }
        catch (Exception e) {
            c.response = "<html><h1>Internal error page could not be rendered</h1></html>".getBytes();
            Container.getLogger().error("SQM Summary page could not load page files with exception: " + e.getMessage());
            c.responseCode = 500;
        }
    }

    private void buildData(AnalysisContext a_ac) {
        Object data = "";
        Object bortle = "";
        String lastLoc = "";
        this.labels = "";
        this.datasetName = new ArrayList();
        this.dataSetData = new ArrayList();
        this.datasetBortle = new ArrayList();
        double value = 0.0;
        int i = 0;
        while (i < ((AnalysisData)a_ac.analysisData.values().toArray()[0]).values.size()) {
            String loc = (String)((AnalysisData)a_ac.analysisData.get((Object)"location")).values.get(i);
            switch (this.valueSelected) {
                case "darkest": {
                    value = (Double)((AnalysisData)a_ac.analysisData.get((Object)"mmax")).values.get(i);
                    break;
                }
                case "average": {
                    value = (Double)((AnalysisData)a_ac.analysisData.get((Object)"mmean")).values.get(i);
                    break;
                }
                case "lightest": {
                    value = (Double)((AnalysisData)a_ac.analysisData.get((Object)"mmin")).values.get(i);
                }
            }
            String mnth = AnalysisCommon.months[(Integer)((AnalysisData)a_ac.analysisData.get((Object)"mth")).values.get(i) - 1];
            if (!this.labels.contains(mnth)) {
                if (!this.labels.isEmpty()) {
                    this.labels = String.valueOf(this.labels) + ", ";
                }
                this.labels = String.valueOf(this.labels) + "'" + mnth + "'";
            }
            loc = loc.split("-")[1].trim();
            if (lastLoc.isEmpty() || !loc.equals(lastLoc)) {
                if (!lastLoc.isEmpty()) {
                    this.dataSetData.add((String)data);
                    this.datasetBortle.add((String)bortle);
                    data = "";
                    bortle = "";
                }
                lastLoc = loc;
                this.datasetName.add(loc);
            }
            if (((String)data).isEmpty()) {
                data = (String)data + "{x: '" + mnth + "', y: " + value + " }";
                bortle = (String)bortle + AnalysisCommon.getBortalColor(value);
            } else {
                data = (String)data + ",{x: '" + mnth + "', y: " + value + " }";
                bortle = (String)bortle + "," + AnalysisCommon.getBortalColor(value);
            }
            ++i;
        }
        this.dataSetData.add((String)data);
        this.datasetBortle.add((String)bortle);
    }

    private String buildKey(AnalysisContext a_ac) {
        Object ret = "<table><tr><th>Year</th></tr><tr><td><form action=\"#\" method=\"POST\">";
        ret = (String)ret + "<select name=\"yearselect\" id=\"yearselect\" onchange=\"this.form.submit()\"> ";
        Object years = "";
        Object regions = "";
        int i = 0;
        while (i < ((AnalysisData)a_ac.analysisData.values().toArray()[0]).values.size()) {
            Integer year = (int)((Integer)((AnalysisData)a_ac.analysisData.get((Object)"myear")).values.get(i));
            String loc = (String)((AnalysisData)a_ac.analysisData.get((Object)"location")).values.get(i);
            if (!((String)years).contains(year.toString())) {
                years = year == this.yearSelected ? (String)years + "<option value=\"" + String.valueOf(year) + "\" selected=true>" + String.valueOf(year) + "</option>" : (String)years + "<option value=\"" + String.valueOf(year) + "\" >" + String.valueOf(year) + "</option>";
            }
            if (!((String)regions).contains(loc = loc.split("-")[0].trim())) {
                regions = loc.equals(this.regionSelected) ? (String)regions + "<option value=\"" + loc + "\" selected=true>" + loc + "</option>" : (String)regions + "<option value=\"" + loc + "\" >" + loc + "</option>";
            }
            ++i;
        }
        ret = (String)ret + (String)years + "</select></form></td></tr>";
        ret = (String)ret + "<tr><th>Region</th></tr><tr><td><form action=\"#\" method=\"POST\">";
        ret = (String)ret + "<select name=\"regionselect\" id=\"regionselect\" onchange=\"this.form.submit()\"> " + (String)regions + "</select></form></td></tr>";
        ret = (String)ret + "<tr><th>Value</th></tr><tr><td><form action=\"#\" method=\"POST\">";
        ret = (String)ret + "<select name=\"valueselect\" id=\"valueselect\" onchange=\"this.form.submit()\">";
        ret = this.valueSelected.equals("darkest") ? (String)ret + "<option value=\"darkest\" selected=true>Darkest</option>" : (String)ret + "<option value=\"darkest\" >Darkest</option>";
        ret = this.valueSelected.equals("average") ? (String)ret + "<option value=\"average\" selected=true>Average</option>" : (String)ret + "<option value=\"average\" >Average</option>";
        ret = this.valueSelected.equals("lightest") ? (String)ret + "<option value=\"lightest\" selected=true>Lightest</option>" : (String)ret + "<option value=\"lightest\" >Lightest</option>";
        ret = (String)ret + "</select>";
        ret = (String)ret + "</table>\n";
        ret = (String)ret + "<table><tr><th>Line Key = Location</th></tr>\n";
        i = 0;
        while (i < this.datasetName.size()) {
            ret = (String)ret + "\t<tr><td style=\"background-color: " + this.colours[i] + "; color: " + this.textColour[i] + "\">" + this.datasetName.get(i) + "</td><td><input type='checkbox' id='ds" + i + "' checked onclick=\"checkOnClick(" + i + ")\"></td></tr>\n";
            ++i;
        }
        ret = (String)ret + "</table>\n";
        ret = (String)ret + "<table><tr><th>Point Key = Bortle</th></tr>\n";
        i = 0;
        while (i < AnalysisCommon.bortleText.length) {
            ret = (String)ret + "\t<tr><td style=\"background-color: " + AnalysisCommon.bortleColours[i] + "; color: " + AnalysisCommon.bortleTextColour[i] + "\">" + AnalysisCommon.bortleText[i] + "</td></tr>\n";
            ++i;
        }
        ret = (String)ret + "</table></form></td></tr>\n";
        return ret;
    }

    private String render(AnalysisContext a_ac) {
        Object graph = "<script>\n";
        graph = (String)graph + "\tconst data = {\n";
        graph = (String)graph + "\t\tlabels: [" + this.labels + "],\n";
        graph = (String)graph + "\t\tdatasets: [\n";
        int i = 0;
        while (i < this.datasetName.size()) {
            graph = i > 0 ? (String)graph + ",\n" : (String)graph + "\n";
            graph = (String)graph + "\t\t\t{ label: '" + this.datasetName.get(i) + "',\n";
            graph = (String)graph + "\t\t\tdata: [" + this.dataSetData.get(i) + "],\n";
            graph = (String)graph + "\t\t\tborderColor: '" + this.colours[i] + "',\n";
            graph = (String)graph + "\t\t\tbackgroundColor: [" + this.datasetBortle.get(i) + "],\n";
            graph = (String)graph + "\t\t\tpointRadius: 10}";
            ++i;
        }
        graph = (String)graph + "\t\t]\n\t};\n";
        graph = (String)graph + "</script>" + a_ac.renderer;
        String ret = this.page.replace("{pagebody}", this.content);
        ret = ret.replace("{Graph}", (CharSequence)graph);
        ret = ret.replace("{key}", this.select);
        return ret;
    }
}

