/*
 * Decompiled with CFR 0.152.
 */
package com.bluesky.clearsky.web;

import com.bluesky.clearsky.AnalysisCommon;
import java.sql.Date;
import java.sql.Time;
import java.time.LocalDate;
import java.util.HashMap;
import org.bluesky.blueprint.analysis.AnalysisClient;
import org.bluesky.blueprint.analysis.AnalysisContext;
import org.bluesky.blueprint.analysis.AnalysisData;
import org.bluesky.blueprint.base.Container;
import org.bluesky.blueprint.base.OPTYPE;
import org.bluesky.blueprint.base.Request;
import org.bluesky.blueprint.base.Service;
import org.bluesky.blueprint.file.FileClient;
import org.bluesky.blueprint.web.WebContext;

public class StaticResultsService
extends Service {
    private static final String MOON_COLOUR = "\"rgb(122, 54, 54)\"";
    private String page = null;
    private String content = "<table><tr><td>{Graph}</td><td>{key}</td></tr></table>";
    private String select;
    private String labels = "";
    private String dataSetData;
    private String dataSetData2;
    private String datasetBortle;
    private String datasetColor;
    private String dateSelected = LocalDate.now().plusDays(-1L).toString();
    private String moon = "none";
    private String moonLabel;
    AnalysisClient acli;

    public StaticResultsService(Container a_owner) {
        super("AppStaticResults", a_owner);
    }

    public void doWork(Request a_request) throws Exception {
        WebContext c = (WebContext)a_request.getContext(OPTYPE.WEB);
        AnalysisContext acd = null;
        AnalysisContext adata = null;
        c.responseCode = 200;
        try {
            if (c.getRequestParameters().containsKey("dateselected")) {
                this.dateSelected = (String)c.getRequestParameters().get("dateselected");
            }
            if (c.getRequestParameters().containsKey("moon")) {
                this.moon = (String)c.getRequestParameters().get("moon");
            }
            this.acli = new AnalysisClient((Service)this);
            HashMap<String, Date> ins = new HashMap<String, Date>();
            acd = this.acli.RunAnalysis("staticdatelist", ins, null);
            if (this.page == null) {
                this.page = new FileClient((Service)this).readTextFile("pages", "pagewithhome.html", null);
                this.page = this.page.replace("{pagename}", "Observatory SQM Readings");
            }
            this.select = this.buildKey(acd);
            ins.clear();
            ins.put("day1", Date.valueOf(LocalDate.parse(this.dateSelected)));
            ins.put("day2", Date.valueOf(LocalDate.parse(this.dateSelected).plusDays(1L)));
            adata = this.acli.RunAnalysis("staticresults", ins, null);
            this.buildData(adata);
            c.response = this.render(adata).getBytes();
        }
        catch (Exception e) {
            c.response = "<html><h1>Internal error page could not be rendered</h1></html>".getBytes();
            Container.getLogger().error("SQM Summary page could not load page files with exception: " + e.getMessage());
            c.responseCode = 500;
        }
    }

    private void buildData(AnalysisContext adata) throws Exception {
        block15: {
            this.labels = "";
            this.dataSetData = "";
            this.datasetBortle = "";
            this.dataSetData2 = "";
            this.datasetColor = "";
            double value = 0.0;
            double moonValue = 0.0;
            double moonMin = 0.0;
            double moonMax = 0.0;
            double moonInc = 0.0;
            if (this.dateSelected == "") break block15;
            int num_points = ((AnalysisData)adata.analysisData.values().toArray()[0]).values.size() - 1;
            if (this.moon.equals("phase") && num_points > 0) {
                this.moonLabel = "Moon Phase (%)";
                moonMin = (Double)((AnalysisData)adata.analysisData.get((Object)"lunar_phase")).values.get(0) * 100.0;
                moonMax = (Double)((AnalysisData)adata.analysisData.get((Object)"lunar_phase")).values.get(num_points) * 100.0;
                moonInc = (moonMax - moonMin) / (double)num_points;
                moonValue = moonMin;
            }
            int i = 0;
            while (i < ((AnalysisData)adata.analysisData.values().toArray()[0]).values.size()) {
                switch (this.moon) {
                    case "alt": {
                        moonValue = (Double)((AnalysisData)adata.analysisData.get((Object)"lunar_alt_deg")).values.get(i);
                        this.moonLabel = "Moon Altitude (Degrees)";
                        break;
                    }
                    case "phase": {
                        moonValue += moonInc;
                        break;
                    }
                    default: {
                        this.moonLabel = "";
                    }
                }
                String time = ((Time)((AnalysisData)adata.analysisData.get((Object)"mtime")).values.get(i)).toString();
                value = (Double)((AnalysisData)adata.analysisData.get((Object)"mpsas")).values.get(i);
                if (!this.labels.isEmpty()) {
                    this.labels = String.valueOf(this.labels) + ", ";
                }
                this.labels = String.valueOf(this.labels) + "'" + time + "'";
                if (this.dataSetData.isEmpty()) {
                    this.dataSetData = String.valueOf(this.dataSetData) + value;
                    this.datasetBortle = String.valueOf(this.datasetBortle) + AnalysisCommon.getBortalColor(value);
                    this.dataSetData2 = String.valueOf(this.dataSetData2) + moonValue;
                    this.datasetColor = String.valueOf(this.datasetColor) + MOON_COLOUR;
                } else {
                    this.dataSetData = String.valueOf(this.dataSetData) + ", " + value;
                    this.datasetBortle = String.valueOf(this.datasetBortle) + "," + AnalysisCommon.getBortalColor(value);
                    this.datasetColor = String.valueOf(this.datasetColor) + ", \"rgb(122, 54, 54)\"";
                    this.dataSetData2 = String.valueOf(this.dataSetData2) + ", " + moonValue;
                }
                ++i;
            }
        }
    }

    private String buildKey(AnalysisContext a_ac) {
        String startDate = ((AnalysisData)a_ac.analysisData.get((Object)"dstart")).values.get(0).toString();
        String endDate = ((AnalysisData)a_ac.analysisData.get((Object)"dend")).values.get(0).toString();
        Object ret = "<table><td><form action=\"#\" method=\"POST\">";
        ret = (String)ret + "<table><tr><th>Moon</th></tr><tr><td><select name=\"moon\" id=\"moon\" onchange=\"this.form.submit()\"> ";
        ret = this.moon.equals("none") ? (String)ret + "<option value=\"none\" selected=true>None</option>" : (String)ret + "<option value=\"none\" >None</option>";
        ret = this.moon.equals("alt") ? (String)ret + "<option value=\"alt\" selected=true>Altitude</option>" : (String)ret + "<option value=\"alt\" >Altitude</option>";
        ret = this.moon.equals("phase") ? (String)ret + "<option value=\"phase\" selected=true>Phase</option>" : (String)ret + "<option value=\"phase\" >Phase</option>";
        ret = (String)ret + "</select></td></tr></table>";
        ret = (String)ret + "<table><tr colspan><th>Select Date (Night of)</th></tr>\n";
        ret = (String)ret + "<tr><td><input type='date' id='dateselected' name='dateselected' value='" + this.dateSelected + "' min='" + startDate + "' max='" + endDate + "' onchange=\"this.form.submit()\"\"></td></tr>\n";
        ret = (String)ret + "</table>\n";
        ret = (String)ret + "<table><tr><th>Point Key = Bortle</th></tr>\n";
        int i = 0;
        while (i < AnalysisCommon.bortleText.length) {
            ret = (String)ret + "\t<tr><td style=\"background-color: " + AnalysisCommon.bortleColours[i] + "; color: " + AnalysisCommon.bortleTextColour[i] + "\">" + AnalysisCommon.bortleText[i] + "</td></tr>\n";
            ++i;
        }
        ret = (String)ret + "</table></form></td></tr>\n";
        return ret;
    }

    private String render(AnalysisContext a_ac) {
        Object graph = "<script>\n";
        graph = (String)graph + "\tconst data = {\n";
        graph = (String)graph + "\t\tlabels: [" + this.labels + "],\n";
        graph = (String)graph + "\t\tdatasets: [\n";
        graph = (String)graph + "\t\t\t{ label: 'MPSAS',\n";
        graph = (String)graph + "\t\t\tdata: [" + this.dataSetData + "],\n";
        graph = (String)graph + "\t\t\tbackgroundColor: [" + this.datasetBortle + "],\n";
        graph = (String)graph + "\t\t\tpointRadius: 4,\n";
        graph = (String)graph + "\t\t\tyAxisID: 'y'},\n";
        if (this.moonLabel != "") {
            graph = (String)graph + "\t\t\t{ label: '" + this.moonLabel + "',\n";
            graph = (String)graph + "\t\t\tdata: [" + this.dataSetData2 + "],\n";
            graph = (String)graph + "\t\t\tbackgroundColor: [" + this.datasetColor + "],\n";
            graph = (String)graph + "\t\t\tborderColor:  [" + this.datasetColor + "],\n";
            graph = (String)graph + "\t\t\tborderDash: [5, 5],\n";
            graph = (String)graph + "\t\t\tpointRadius: 0,\n";
            graph = (String)graph + "\t\t\tyAxisID: 'y1'}\n";
        }
        graph = (String)graph + "\t\t]";
        graph = (String)graph + "\n\t};\n";
        graph = (String)graph + "</script>" + a_ac.renderer;
        graph = this.moonLabel != "" ? ((String)graph).replace("<<set2>>", "     y1: {\n        type: 'linear',\r\n        display: true,\r\n        position: 'right',\r\n        grid: {\r\n          drawOnChartArea: false,\r\n        }\r\n      }") : ((String)graph).replace("<<set2>>", "");
        graph = this.dateSelected != "" ? ((String)graph).replace("<<title>>", "MPSAS for night of " + this.dateSelected) : ((String)graph).replace("<<title>>", "");
        String ret = this.page.replace("{pagebody}", this.content);
        ret = ret.replace("{Graph}", (CharSequence)graph);
        ret = ret.replace("{key}", this.select);
        return ret;
    }
}

